# NHSE Repository in a Box (RIB)
#
# The authors of this software are Paul McMahan and Jeff Horner.
# Copyright (c) 1997 by the University of Tennessee.
# Permission to use, copy, modify, and distribute this software for any
# purpose without fee is hereby granted, provided that this entire notice
# is included in all copies of any software which is or includes a copy
# or modification of this software and in all copies of the supporting
# documentation for such software.
# THIS SOFTWARE IS BEING PROVIDED "AS IS", WITHOUT ANY EXPRESS OR IMPLIED
# WARRANTY.  IN PARTICULAR, NEITHER THE AUTHORS NOR UNIVERSITY OF TENNESSEE
# MAKE ANY REPRESENTATION OR WARRANTY OF ANY KIND CONCERNING THE
# MERCHANTABILITY OF THIS SOFTWARE OR ITS FITNESS FOR ANY PARTICULAR PURPOSE.
#
# $Id: describe_field.pl,v 1.1.1.1 1997/12/10 15:59:31 jhorner Exp $
#
# $Log: describe_field.pl,v $
# Revision 1.1.1.1  1997/12/10 15:59:31  jhorner
# RIB pre 1.0
#
# Revision 1.2  1997/05/26 13:40:18  mcmahan
# removed unused variable $cgipath
#
# Revision 1.1  1997/05/06 18:16:54  jhorner
# Initial revision
#


use RIB::Util ();
my %in = RIB::Util->ReadParse();
use RIB::ConfigParser ();

my $util = RIB::Util->new();
$util->PrintHeader();

#############################################################################

$repository = $util->GetRepoName();
unless ($repository) {
  $util->ErrorMessage("A repository was not specified in your input");
}

$back_to_top = $util->BackToTop($repository);

$filepath = $util->GetRibDir() . "/repositories/" . $repository;

my $config = RIB::ConfigParser->new();
$config->load_class($in{class}, $filepath . "/conf/BIDM.conf");

print "<head><title>$in{field}</title></head>\n";
print "<body bgcolor=#FFFFF0>\n";
print "<center>\n";
print "<table width=100% border cellpadding=10>\n";

if ($config->IsRelationship($in{field})) {
  $is_rel=1;
  $colspan=5;
} else {
  $is_rel=0;
  $colspan=4;
}

# name
print "<tr bgcolor=#FFFFFF>\n";
print "<td align=center colspan=$colspan>\n";
print "<font size=+2><strong>$in{field}</strong></font>\n";
print "</td>\n";
print "</tr>\n";
  
# description
print "<tr bgcolor=#FFFFFF>\n";
print "<td align=center colspan=$colspan>\n";
if ($config->Desc($in{field})) {
  print $config->Desc($in{field});
} else {
  print "No description of this field is provided in ";
  print "<a href=", $util->GetRibUrl(), "/repositories/$repository/",
        "conf/BIDM.conf>";
  print "this repository's configuration file</a>.\n";
}
print "</td>\n";
print "</tr>\n";

print "<tr bgcolor=#FFFFFF>\n";
print "<th>Type</th>\n";
$is_rel and print "<th>Target Class</th>\n";
print "<th>Multiple?</th>\n";
print "<th>Required?</th>\n";
print "<td align=center><strong>Alternate Name</strong><br>(for software ";
print "catalog)</td>\n";
print "</tr>\n";

print "<tr bgcolor=#FFFFFF>\n";
# Attr/Rel
print "<td align=center>\n";
$is_rel ? print "Relationship" : print "Attribute";
print "</td>\n";
  
# target class (if relationship)
$is_rel and print "<td align=center>".$config->Destination($in{field})."</td>";

# Multiple?
print "<td align=center>\n";
$config->IsMultiple($in{field}) ? print "Yes" : print "No";
print "</td>\n";

# Required?
print "<td align=center>\n";
$config->IsRequired($in{field}) ? print "Yes" : print "No";
print "</td>\n";

# Alt name
print "<td align=center>\n";
$alt = $config->Alt($in{field});
if ($alt && $alt ne $in{field}) {
  print $alt;
} else {
  print "-";
}
print "</td>\n";

print "</table>\n";
print "</body>\n";
