# NHSE Repository in a Box (RIB)
#
# The authors of this software are Paul McMahan and Jeff Horner.
# Copyright (c) 1997 by the University of Tennessee.
# Permission to use, copy, modify, and distribute this software for any
# purpose without fee is hereby granted, provided that this entire notice
# is included in all copies of any software which is or includes a copy
# or modification of this software and in all copies of the supporting
# documentation for such software.
# THIS SOFTWARE IS BEING PROVIDED "AS IS", WITHOUT ANY EXPRESS OR IMPLIED
# WARRANTY.  IN PARTICULAR, NEITHER THE AUTHORS NOR UNIVERSITY OF TENNESSEE
# MAKE ANY REPRESENTATION OR WARRANTY OF ANY KIND CONCERNING THE
# MERCHANTABILITY OF THIS SOFTWARE OR ITS FITNESS FOR ANY PARTICULAR PURPOSE.
#

use RIB::Util ();
use strict;

$|=1; # unbuffer

my $util = RIB::Util->new();
my %in = RIB::Util->ReadParse();
#$util->PrintHeader();
print "Content-type: text/plain\n\n";

(my $repository = $in{repository}) or exit;

my $filepath = $util->GetRibDir() . "/repositories/" . $repository;
my $urlpath  = $util->GetRibUrl() . "/repositories/" . $repository;

my $links;
my $file = $util->GetRibDir ."/repositories/$repository/catalog/.nonlocal";
if(-e $file and -s $file){
    open(N,$file);
      # Begin Block
    { local($/) = undef;
      my $tmp = <N>;
      no strict 'vars';
      $links = eval "my $tmp";
      exit 0 if $@;
    }
}
my $link;
my @tmp_list;
foreach $link (@{$links}){  push @tmp_list, $link->{URL}; }

foreach (sort @tmp_list) {
  print "$_\n";
}
