# NHSE Repository in a Box (RIB)
#
# The author of this software is Paul McMahan.
# Copyright (c) 1998 by the University of Tennessee.
# Permission to use, copy, modify, and distribute this software for any
# purpose without fee is hereby granted, provided that this entire notice
# is included in all copies of any software which is or includes a copy
# or modification of this software and in all copies of the supporting
# documentation for such software.
# THIS SOFTWARE IS BEING PROVIDED "AS IS", WITHOUT ANY EXPRESS OR IMPLIED
# WARRANTY.  IN PARTICULAR, NEITHER THE AUTHORS NOR UNIVERSITY OF TENNESSEE
# MAKE ANY REPRESENTATION OR WARRANTY OF ANY KIND CONCERNING THE
# MERCHANTABILITY OF THIS SOFTWARE OR ITS FITNESS FOR ANY PARTICULAR PURPOSE.
#

use strict;
use RIB::Util ();

my $util = RIB::Util->new();
my %in = RIB::Util->ReadParse();
$util->PrintHeader();

my $repository = $util->GetRepoName();
if (!$repository) {
  $util->ErrorMessage("repository was not specifed in your input.");
}

my $filepath = $util->GetRibDir() . "/repositories/" . $repository;
my $urlpath  = $util->GetRibUrl() . "/repositories/" . $repository;
my $back_to_top = $util->BackToTop($repository);

my $top = "<head><title>Check disk space for "
     . "$repository</title></head>\n"
     . "<body bgcolor=#FFFFF0>"
     . "<center>"
     . "<h1>Check disk space for $repository</h1>\n"
     . "</center>"
     . "<p><hr><p>\n";


$|=1;
print $top;
print "<P>\n<strong>Disk Space Available for uploading</strong><p>\n";

# try to find out if the df command exists on this machine
my $path;
my $df_check=0;
$ENV{PATH} .= ":/bin:/usr/local/bin:/usr/5bin";
foreach $path (split /:/, $ENV{PATH}) {
  if (-x "$path/df") {
    $df_check="$path/df";
    last;
  }
}
my $dir = "$filepath/files";
if ($df_check) {
  print "The command <pre>$df_check $dir</pre>\n";
  print "reports the following about your software upload direcotry:<pre>";
  system ("$df_check $dir");
  print "</pre>\n<p>If you're not sure how to interpret these numbers then ";
  print "you might want to type <i>man df</i> on your RIB machine\n";
  print "or check with your system administrator.\n";
} else {
  print "The command <strong>df</strong> cannot be found in your http user's path\n";
  print "This command is used by RIB to query your filesystem.  Since RIB cannot\n";
  print "find this command it cannot report the amount of disk space available.\n";
  print "<p>If you would like to manually check the disk space available then you\n";
  print "should check the directory $dir.\n";
}

print $back_to_top;
print "<a href=manage_software_files.pl>Manage software files for $repository</a>\n";
exit;
