# NHSE Repository in a Box (RIB)
#
# The authors of this software are Paul McMahan and Jeff Horner.
# Copyright (c) 1997 by the University of Tennessee.
# Permission to use, copy, modify, and distribute this software for any
# purpose without fee is hereby granted, provided that this entire notice
# is included in all copies of any software which is or includes a copy
# or modification of this software and in all copies of the supporting
# documentation for such software.
# THIS SOFTWARE IS BEING PROVIDED "AS IS", WITHOUT ANY EXPRESS OR IMPLIED
# WARRANTY.  IN PARTICULAR, NEITHER THE AUTHORS NOR UNIVERSITY OF TENNESSEE
# MAKE ANY REPRESENTATION OR WARRANTY OF ANY KIND CONCERNING THE
# MERCHANTABILITY OF THIS SOFTWARE OR ITS FITNESS FOR ANY PARTICULAR PURPOSE.
#

use strict;
use RIB::Util ();

$|=1; # unbuffer

#RIB::Util->PrintHeader();
print "Content-type: text/plain\n\n";

my %in = RIB::Util->ReadParse();
#my $repository = RIB::Util->GetRepoName();
(my $repository = $in{repository}) or exit 1;

my $filepath = RIB::Util->GetRibDir() . "/repositories/$repository/objects/Asset";
my $urlpath  = RIB::Util->GetRibUrl() . "/repositories/$repository/objects/Asset";

if (opendir(DIR,"$filepath")){
    foreach ( sort grep(/\.[hH][tT][mM][lL]?$/,readdir(DIR))){
	print "$urlpath/$_\n";
    }
}
