# NHSE Repository in a Box (RIB)
#
# The authors of this software are Paul McMahan and Jeff Horner.
# Copyright (c) 1997 by the University of Tennessee.
# Permission to use, copy, modify, and distribute this software for any
# purpose without fee is hereby granted, provided that this entire notice
# is included in all copies of any software which is or includes a copy
# or modification of this software and in all copies of the supporting
# documentation for such software.
# THIS SOFTWARE IS BEING PROVIDED "AS IS", WITHOUT ANY EXPRESS OR IMPLIED
# WARRANTY.  IN PARTICULAR, NEITHER THE AUTHORS NOR UNIVERSITY OF TENNESSEE
# MAKE ANY REPRESENTATION OR WARRANTY OF ANY KIND CONCERNING THE
# MERCHANTABILITY OF THIS SOFTWARE OR ITS FITNESS FOR ANY PARTICULAR PURPOSE.
#
# $Id: delete_object.pl,v 1.1.1.1 1997/12/10 15:59:31 jhorner Exp $
#
# $Log: delete_object.pl,v $
# Revision 1.1.1.1  1997/12/10 15:59:31  jhorner
# RIB pre 1.0
#
# Revision 1.1  1997/05/06 18:16:44  jhorner
# Initial revision
#

use RIB::Util ();

my $util = RIB::Util->new();
my %in = RIB::Util->ReadParse();
$util->PrintHeader;

$repository = $util->GetRepoName();
if (!$repository) {
  $util->ErrorMessage("Your input to this script didn't specify a repository");
} elsif (!$in{class}) {
  $util->ErrorMessage("Your input to this script didn't specify a class");
}

$RIBDIR = $util->GetRibDir();
$back_to_top = $util->BackToTop($repository);

$top = "<head><title>$in{class} Deletion for &quot;$repository&quot;"
     . "</title></head>\n"
     . "<body bgcolor=#fffff0><center><h1>\n"
     . "$in{class} Deletion for &quot;$repository&quot;\n"
     . "</h1></center><p><hr><p>\n";

if (exists $in{step} && defined $in{step} && $in{step}==3) {
  if ($in{object}) {
    unless (unlink "$RIBDIR/repositories/$repository/catalog/$in{class}/$in{object}.html") {
      $util->ErrorMessage("Couldn't delete $RIBDIR/repositories/$repository/catalog/$in{class}/$in{object}.html "
                       . "<p>Reason: $!");
    }
    if (unlink "$RIBDIR/repositories/$repository/objects/$in{class}/$in{object}.html") {
      print $top;
      print "The $in{class} file named ";
      print "<strong>$in{object}</strong> has been deleted\n";
      print $back_to_top;
      print "<p><a href=delete_object.pl?";
      print "class=$in{class}>";
      print "Delete another $in{class} from this repository</a>\n";
    } else {
      $util->ErrorMessage("Couldn't delete $RIBDIR/repositories/$repository/objects/$in{class}/$in{object}.html "
                       . "<p>Reason: $!");
    }
  } else {
    $util->ErrorMessage("Your input to this script didn't specify an object "
                     . "description file to delete");
  }
  exit;
} elsif (exists $in{step} && defined $in{step} && $in{step}==2) {
  print $top;
  if ($in{object}) {
    print "Are you sure you wish to delete the following \n";
    print "$in{class} file?<p>\n";
    print "<ul>\n";
    print "<li><a href=", $util->GetRibUrl(), "/repositories/",
          "$repository/objects/$in{class}/$in{object}.html>";
    print "$in{object}</a> ";
    print "(Click to see its contents).\n";
    print "</ul>\n";
    print "<br><table>\n";
    print "<tr>\n";
    print "<td>\n";
    print "<form method=post action=delete_object.pl>\n";
    print "<input type=hidden name=step value=3>\n";
    print "<input type=hidden name=class value=$in{class}>\n";
    print "<input type=hidden name=object value=$in{object}>\n";
    print "<input type=submit value=Yes>\n";
    print "</form>\n";
    print "</td>\n";
    print "<td>\n";
    print "<form method=post action=delete_object.pl>\n";
    print "<input type=hidden name=step value=1>\n";
    print "<input type=hidden name=class value=$in{class}>\n";
    print "<input type=submit value=No>\n";
    print "</form>\n";
    print "</td>\n";
    print "</table>\n";
  } else {
    print "You didn't select a $in{class} file to delete.\n";
  }
  print $back_to_top;
  print "</body>\n";
  exit;
} else {

  # Here's the code where we list the objects and possibly the
  # links to delete. Only cgi variable set is 'class=Asset'.
  #
  if (!opendir(DIR,"$RIBDIR/repositories/$repository/objects/$in{class}")) {
    $util->ErrorMessage("Couldn't open the directory "
                . "$RIBDIR/repositories/$repository/objects/$in{class} "
                . "to check for $in{class} files.\n"
                . " <p>Reason : $!");
  }
  print $top;
  foreach $file (sort readdir(DIR)) {
    next unless -f "$RIBDIR/repositories/$repository/objects/$in{class}/$file";
    $file =~ s/\.html$//;
    $options .= "<li><a href=delete_object.pl?object=$file&step=2&";
    $options .= "class=$in{class}>$file</a>\n";
  }
  if ($options) {
    print "Please select the $in{class} that you wish to delete.<br>\n";
    print "<ul>$options</ul>\n"; 
  } else {
    print "No $in{class} files currently exist for ";
    print "&quot;$repository&quot;\n";
  }
  print $back_to_top;
  print "</body>\n";
  exit;
}
