# NHSE Repository in a Box (RIB)
#
# The authors of this software are Paul McMahan and Jeff Horner.
# Copyright (c) 1997 by the University of Tennessee.
# Permission to use, copy, modify, and distribute this software for any
# purpose without fee is hereby granted, provided that this entire notice
# is included in all copies of any software which is or includes a copy
# or modification of this software and in all copies of the supporting
# documentation for such software.
# THIS SOFTWARE IS BEING PROVIDED "AS IS", WITHOUT ANY EXPRESS OR IMPLIED
# WARRANTY.  IN PARTICULAR, NEITHER THE AUTHORS NOR UNIVERSITY OF TENNESSEE
# MAKE ANY REPRESENTATION OR WARRANTY OF ANY KIND CONCERNING THE
# MERCHANTABILITY OF THIS SOFTWARE OR ITS FITNESS FOR ANY PARTICULAR PURPOSE.
#
# $Id: delete_nonlocal_link.pl,v 1.1.1.1 1997/12/10 15:59:32 jhorner Exp $
#
# $Log: delete_nonlocal_link.pl,v $
# Revision 1.1.1.1  1997/12/10 15:59:32  jhorner
# RIB pre 1.0
#
# Revision 1.1  1997/05/06 18:16:19  jhorner
# Initial revision
#


use RIB::Util ();
my %in = RIB::Util->ReadParse();
use HTML::Entities ();

my $util = RIB::Util->new();
$util->PrintHeader();

$repository = $util->GetRepoName();
if (!$repository) {
  $util->ErrorMessage("repository was not specifed in your input.");
}

my $filepath = $util->GetRibDir() . "/repositories/" . $repository;
my $urlpath  = $util->GetRibUrl() . "/repositories/" . $repository;

$back_to_top = $util->BackToTop($repository);

$top = "<head><title>Delete catalog links for &quot;$repository&quot;"
     . "</title></head>\n"
     . "<body bgcolor=#FFFFF0>\n"
     . "<h1>Delete catalog link for $repository</h1>\n"
     . "<p><hr><p>\n";

if (!(-f "$filepath/catalog/.nonlocal") or -z "$filepath/catalog/.nonlocal") {
  print $top;
  print "This repository does not contain links to any foreign assets.\n";
  print $back_to_top;
  exit;
}

# We have now verified that the user wants to delete
# $in{url}, so do it.
if ($in{verify}) {
  $| = 1;
  $in{url} or $util->ErrorMessage("Your input didn't specify a url");
  #open the current list of urls to foreign assets
  unless ($util->InitNonLocal($repository)){
    $util->ErrorMessage('Access to the links is currently locked.'
       .' Please try pressing the Reload button in your web client.'
       .' If this message persists, contact your RIB administrator<br>');
  }
  # Remove $in{url}
  $util->RemoveNonLocalLink($in{url});
  $util->CommitNonLocal();
  print $top;
  print "The link was successfully deleted.\n";
  print $back_to_top;
  unless (-z "$filepath/catalog/.nonlocal") {
    print "<p><a href=delete_nonlocal_link.pl>";
    print "Delete another foreign link for this repository's catalog</a>\n";
  }
  exit;
} elsif ($in{url}) {
  print $top;
  print "Are you sure that you want to delete the following url ";
  print "from this repository's list of links to foreign Assets?<p>\n";
  print "<dl><dd>$in{url}</dl>\n";
  print "<table><tr><td>\n";
  print "<form action=delete_nonlocal_link.pl method=post>";
  print "<input type=hidden name=url value=$in{url}>";
  print "<input type=hidden name=verify value=1>";
  print "<input type=submit value=Yes>";
  print "</form>\n";
  print "</td><td>\n";
  print "<form action=delete_nonlocal_link.pl method=post>";
  print "<input type=submit value=No>";
  print "</form>\n";
  print "</td></tr></table>\n";
  print $back_to_top;
  exit;

# We were called with no args from create_object_choices.pl
# list the urls.
} else {
  print $top;
  if ($util->InitNonLocal($repository)){
      print "Please choose the link that you want to delete :\n<ul>\n";
      foreach ( $util->NonLocalLink ){
	 print '<li><a href="delete_nonlocal_link.pl?url=',
	    ${_}->{URL},'">',${_}->{URL},"</a>\n";
      }
      print "</ul>\n";
      $util->CommitNonLocal();
  } else {
   $util->ErrorMessage('Access to the links is currently locked.'
       .' Please try pressing the Reload button in your web client.'
       .' If this message persists, contact your RIB administrator<br>');
  }
  print $back_to_top;
}
