# NHSE Repository in a Box (RIB)
#
# The authors of this software are Paul McMahan and Jeff Horner.
# Copyright (c) 1997 by the University of Tennessee.
# Permission to use, copy, modify, and distribute this software for any
# purpose without fee is hereby granted, provided that this entire notice
# is included in all copies of any software which is or includes a copy
# or modification of this software and in all copies of the supporting
# documentation for such software.
# THIS SOFTWARE IS BEING PROVIDED "AS IS", WITHOUT ANY EXPRESS OR IMPLIED
# WARRANTY.  IN PARTICULAR, NEITHER THE AUTHORS NOR UNIVERSITY OF TENNESSEE
# MAKE ANY REPRESENTATION OR WARRANTY OF ANY KIND CONCERNING THE
# MERCHANTABILITY OF THIS SOFTWARE OR ITS FITNESS FOR ANY PARTICULAR PURPOSE.
#
# $Id: RIB.pl,v 1.2 1998/01/23 20:15:27 rib Exp $
#
# $Log: RIB.pl,v $
# Revision 1.2  1998/01/23 20:15:27  rib
# added more pointers to the RIB Quickstart guide
#
# Revision 1.1.1.1  1997/12/10 15:59:32  jhorner
# RIB pre 1.0
#
# Revision 1.2  1997/05/26 14:45:05  mcmahan
# fixed script to not use "../" when it tries to reference certain
# directory.  it now uses RIB::Util::GetRibDir().  Also, added "admin/"
# to the "cgi-bin/" paths where appropriate - this is to fix the access
# control bug
#
# Revision 1.1  1997/05/06 18:19:15  jhorner
# Initial revision
#

use strict;
use RIB::Util;
my $util = RIB::Util->new();

$util->PrintHeader();

#############################################################################

my (@repositories, $dirname, $repository);
if (opendir(REPOSITORY_DIR, $util->GetRibDir() . "/repositories")) {
  foreach $dirname (readdir(REPOSITORY_DIR)) {
    next unless -d $util->GetRibDir() . "/repositories/$dirname";
    next if $dirname =~ /^\./;
    push (@repositories, $dirname);
  }
  closedir(REPOSITORY_DIR);
}
else {
  $util->ErrorMessage("Couldn't open your repositories directory.");
}
print "<head><title>RIB administration page</title></head>\n";
print "<body bgcolor=#FFFFF0>\n";
print "<center>\n";
print "<table>\n";
print "<tr>\n";
print "<td>\n";
print "<a href=http://www.nhse.org/>";
print "<img src=", $util->GetRibUrl(), "/images/NHSELOGO_small.gif>";
print "</a>";
print "</td>\n";
print "<td valign=center>\n";
print "<font size=+2><strong>RIB Administration Page</strong></font>\n";
print "</td>\n";
print "<td>\n";
print "<a href=http://www.nhse.org/>";
print "<img src=", $util->GetRibUrl(), "/images/NHSELOGO_small.gif>";
print "</a>";
print "</td>\n";
print "</tr>\n";
print "</table>\n";
print "</center>\n";
print "<p><hr><p>\n";

print "<ul>\n";
if (@repositories) {
  print "<li><strong>Select an existing repository ";
  print " to administrate </strong>";
  print "[<i><a target=help ",
    "href=", $util->GetRibUrl(), "/help/help.html#bugs_navigation>";
  print "help on access control</a></i>] :\n";
  print "<ul>\n";
  foreach $repository (sort {lc($a) cmp lc($b)} @repositories) {
    print "<li><a href=", $util->GetRibUrl(), 
          "/cgi-bin/admin/repositories/$repository/admin_repository.pl>",
          "$repository</a>\n";
  }
print "</ul>\n";
print "<p>\n";
}
print "<li><a href=create_delete_repo/create_repository.pl>";
print "<strong>Create a new repository</strong></a>\n";
print "[<i><a target=help",
      " href=", $util->GetRibUrl(), "/help/help.html#create_repository>";
print "help</a></i>]<p>\n";
print "<p>\n";
if (@repositories) {
  print "<li><a href=create_delete_repo/delete_repository.pl>";
  print "<strong>Delete a repository</strong></a>\n";
  print "[<i><a target=help",
        " href=", $util->GetRibUrl(), "/help/help.html#delete_repository>";
  print "help</a></i>]<p>\n";
  print "<p>\n";
}
print "<li><a href=", $util->GetRibUrl(), "/help/help.html>";
print "<strong>View the RIB User's Guide</strong></a>\n";
print "<p>\n";
print "<li><a href=", $util->GetRibUrl(), "/help/quickguide.html>";
print "<strong>View the RIB Quickstart Guide</strong></a>\n";
print "<p>\n";
print "<li><a href=http://www.nhse.org/RIB/>";
print "<strong>Visit the RIB home page</strong></a>\n";
print "</ul>\n";
print "<p><hr><p>\n";
print "<i>\n";
print "Repository in a Box (RIB) is a software package for setting up\n";
print "and maintaining software repositories. RIB has been developed\n";
print "by the <a href=http://www.nhse.org/>National High Performance ";
print "Software Exchange</a>\n";
print "Technical Team.\n";
print "For examples of repositories that use RIB, see\n";
print "<a href=http://www.nhse.org/ptlib/>PTLIB</a> and\n";
print "<a href=http://www.nhse.org/hpc-netlib/>HPC-Netlib</a>.\n";
print "Using RIB will allow your repository to interoperate with other\n";
print "NHSE repositories, as well as with a growing number of other\n";
print "software repositories that use the <a href=", $util->GetRibUrl(),
      "/help/help.html#data_model>\n";
print "Basic Interoperability Data Model (BIDM)</a>, which is the IEEE\n";
print "standard for interoperable software cataloging on the Internet.<p>\n";
print "Please direct questions or comments about RIB to\n";
print "<a href=mailto:nhse-tech\@nhse.org>nhse-tech\@nhse.org</a>.\n";
print "</i>\n";

print "<p><hr>\n";

print "</body>\n";
exit;
