#!/usr/local/bin/perl
use lib '/usr/local/rib/lib';
# NHSE Repository in a Box (RIB)
#
# The authors of this software are Paul McMahan and Jeff Horner.
# Copyright (c) 1997 by the University of Tennessee.
# Permission to use, copy, modify, and distribute this software for any
# purpose without fee is hereby granted, provided that this entire notice
# is included in all copies of any software which is or includes a copy
# or modification of this software and in all copies of the supporting
# documentation for such software.
# THIS SOFTWARE IS BEING PROVIDED "AS IS", WITHOUT ANY EXPRESS OR IMPLIED
# WARRANTY.  IN PARTICULAR, NEITHER THE AUTHORS NOR UNIVERSITY OF TENNESSEE
# MAKE ANY REPRESENTATION OR WARRANTY OF ANY KIND CONCERNING THE
# MERCHANTABILITY OF THIS SOFTWARE OR ITS FITNESS FOR ANY PARTICULAR PURPOSE.
#
# $Id: browse_objects.pl,v 1.1.1.1 1997/12/10 15:59:32 jhorner Exp $
#
# $Log: browse_objects.pl,v $
# Revision 1.1.1.1  1997/12/10 15:59:32  jhorner
# RIB pre 1.0
#
# Revision 1.2  1997/05/06 20:08:13  jhorner
# Removed the 'rename' feature.
#
# Revision 1.1  1997/05/06 18:15:16  jhorner
# Initial revision


use RIB::Util ();

my $util = RIB::Util->new();
my %in = RIB::Util->ReadParse();
$util->PrintHeader;

$repository = $util->GetRepoName();
if (!$repository) {
  $util->ErrorMessage("Your input to this script didn't specify a repository");
} elsif (!$in{class}) {
  $util->ErrorMessage("Your input to this script didn't specify a class");
}

$RIBDIR = $util->GetRibDir();
$RIBURL = $util->GetRibUrl();
$back_to_top = $util->BackToTop($repository);

$top = "<head><title>$in{class} description file "
     . "browser for &quot;$repository&quot;"
     . "</title></head>\n"
     . "<body bgcolor=#FFFFF0><center><h1>\n"
     . "$in{class} description file browser for \"$repository\"\n"
     . "</h1></center><p><hr><p>\n";

if (!opendir(DIR,"$RIBDIR/repositories/$repository/objects/$in{class}")) {
  $util->ErrorMessage("Couldn't open the directory "
              . "$RIBDIR/repositories/$repository/objects/$in{class} "
              . "to check for $in{class} object description files.\n"
              . "<p>Reason : $!");
}
print $top;
foreach $file (sort readdir(DIR)) {
  next if (-d $file);
  ($perty_name = $file) =~ s/\.html$//;
  $options .= "<dt><strong>$perty_name</strong><dd><a href=$RIBURL";
  $options .= "/repositories/$repository/objects/$in{class}/$file>";
  $options .= "meta data</a>";
  if (-f "$RIBDIR/repositories/$repository/catalog/$in{class}/$file"){
      $options .= " or <a href=$RIBURL";
      $options .= "/repositories/$repository/catalog/$in{class}/$file>";
      $options .= "catalog entry</a>\n";
  }
}

if ($options) {
  print "Please select the $in{class} description file ";
  print "that you wish to view.<br>\n";
  print "<dl>\n$options</dl>\n"; 
} else {
  print "No $in{class} object description files currently exist for ";
  print "&quot;$repository&quot;\n";
}
print $back_to_top;
print "</body>\n";
exit;
