
/* 
   User-defined application context for examples ex8.c and 
   ex9.c - contains data needed by the application-provided 
   callback routine, FormFunction(). 
*/
typedef struct {
   double   lidvelocity, prandtl, grashof; 
   int      mx, my;            /* discretization in x, y directions */
   int      mc;                /* components in unknown vector */
   Vec      localX, localF;    /* ghosted local vector */
   DA       da;                /* distributed array data structure (unknowns) */
   int      rank;              /* processor rank */
   int      size;              /* number of processors */
   MPI_Comm comm;              /* MPI communicator */
   int      icycle, ncycles;   /* current/total cycles through problem */
   Vec      x_old;             /* old solution vector */
   char     **label;           /* labels for components */
   int      print_grid;        /* flag - 1 indicates printing grid info */
   int      print_vecs;        /* flag - 1 indicates printing vectors */
   int      draw_contours;     /* flag - 1 indicates drawing contours */
} AppCtx;
