!
!      mpintfgx - Interface to MINPACK-2 routines for evaluating 
!                 the initial guess x, function f(x), and gradient g(x)
!                 on a single processor
!
!                 task = 'XS' - compute initial guess
!                 task = 'F'  - compute function
!                 task = 'G'  - compute gradient
!                 task = 'FG' - compute function and gradient
!
       integer function mpintf( problem, mx, my, n, x, f, g,            &
     &                          w, param, task )

       double precision  f, x(*), g(*), w(*), param, b
       integer           problem, mx, my, n, iparam, error
       character*(*)     task

       error = 0
       if (problem .eq. 1) then
          call deptfg( mx, my, x, f, g, task, param )
       else if (problem .eq. 2) then
          b = 10.0
          call dpjbfg( mx, my, x, f, g, task, param, b )
       else if (problem .eq. 3) then
          call dmsabc( mx, my, w, w(mx+3), w(2*mx+5), w(2*mx+my+7) )
          call dmsafg( mx, my, x, f, g, task, w, w(mx+3), w(2*mx+5),    &
     &                 w(2*mx+my+7) )
       else if (problem .eq. 4) then
          call dodcfg( mx, my, x, f, g, task, param )
       else if (problem .eq. 5) then
          call dsscfg( mx, my, x, f, g, task, param )
       else if (problem .eq. 6) then
          call dgl1fg( n, x, f, g, task, param )
       else if (problem .eq. 7) then
          iparam = int(param)
          call dgl2fg( mx, my, x, f, g, task, w, iparam )
       else
!
!      Removed this write statement because we could not ex1.c to 
!      link with it using this file that has Fortran IO in it.
!      We only had this problem on the DEC alpha.
!
!          write(6,*) 'Invalid problem number.'
          error = 1
       endif

       mpintf = error
       return
       end
