#ifdef PETSC_RCS_HEADER
static char vcid[] = "$Id: ilubs.c,v 1.22 1998/04/03 23:15:15 bsmith Exp $";
#endif
/*
   Defines a ILU factorization preconditioner with BlockSolve95 interface.
   See notes about scaling and permuting at the top of the file iccbs.c.
*/
#include "petsc.h"

#if defined(HAVE_BLOCKSOLVE) && !defined(USE_PETSC_COMPLEX)
#include "src/pc/pcimpl.h"
#include "src/pc/impls/ilu/ilu.h"
#include "src/ksp/kspimpl.h"
#include "src/mat/impls/rowbs/mpi/mpirowbs.h"

/* BlockSolve implementation interface */

typedef struct {
  int    blocksize;     /* number of systems to solve */
  int    pre_option;    /* preconditioner, one of PRE_DIAG,
                           PRE_STICCG, PRE_SSOR, PRE_BJACOBI */
  double rtol;
  int    max_it;
  double rnorm;
  int    guess_zero;
} PCiBS;


#undef __FUNC__  
#define __FUNC__ "PCDestroy_ILU_MPIRowbs"
static int PCDestroy_ILU_MPIRowbs(PC pc)
{
  PC_ILU *ilu = (PC_ILU *) pc->data;
  PCiBS  *ilubs = (PCiBS *) ilu->implctx; 
  int    ierr;

  PetscFunctionBegin;  
  PetscFree(ilubs);
  ierr = MatDestroy(ilu->fact); CHKERRQ(ierr);
  if (ilu->row && ilu->col && ilu->row != ilu->col) ISDestroy(ilu->row);
  if (ilu->col) ISDestroy(ilu->col);
  PetscFree(ilu); 
  PetscFunctionReturn(0);
}

extern int PCPreSolve_MPIRowbs(PC,KSP);
extern int PCPostSolve_MPIRowbs(PC,KSP);

#undef __FUNC__  
#define __FUNC__ "PCSetUp_ILU_MPIRowbs"
int PCSetUp_ILU_MPIRowbs(PC pc)
{
  PC_ILU       *ilu = (PC_ILU *) pc->data;
  PCiBS        *ilubs;
  MatStructure pflag;
  Mat          Amat, Pmat;
  int          ierr;

  PetscFunctionBegin;  
  ierr = PCGetOperators(pc,&Amat,&Pmat,&pflag); CHKERRQ(ierr);
  if (Amat != Pmat && Amat->type == MATMPIROWBS) {
    SETERRQ(PETSC_ERR_SUP,0,"Does not support different Amat and\n\
                 Pmat with MATMPIROWBS format for both.  Use a different format for\n\
                 Amat (e.g., MATMPIAIJ) and keep Pmat the same.");
  }

  pc->destroy       = PCDestroy_ILU_MPIRowbs;
  ilu->implctx      = (void *) (ilubs = PetscNew(PCiBS)); CHKPTRQ(ilubs);
  PLogObjectMemory(pc,sizeof(PCiBS));

  ilubs->blocksize  = 0;
  ilubs->pre_option = 0;
  ilubs->rtol       = 0;
  ilubs->max_it     = 0;
  ilubs->rnorm      = 0.0;
  ilubs->guess_zero = 0;
  if (Amat->type == MATMPIROWBS) {
    pc->presolve    = PCPreSolve_MPIRowbs;
    pc->postsolve   = PCPostSolve_MPIRowbs;
  }
  PetscFunctionReturn(0);
}

#else
#undef __FUNC__  
#define __FUNC__ "MatNull_MPIRowbs_ILU"
int MatNull_MPIRowbs_ILU(void)
{
  PetscFunctionBegin;  
  PetscFunctionReturn(0);
}
#endif

