#ifdef PETSC_RCS_HEADER
static char vcid[] = "$Id: rect.c,v 1.5 1997/10/19 03:31:33 bsmith Exp $";
#endif

/*
   Basic routinues for rectangular grids
*/
#include "src/gvec/impls/rectangular/rectimpl.h"         /*I "gvec.h" I*/

#undef __FUNC__  
#define __FUNC__ "GridDataRectangularGetDA" 
int GridDataRectangularGetDA(GridData gridd,DA *da)
{
  GridData_Rectangular *s = (GridData_Rectangular *) gridd->data;

  PetscFunctionBegin;
  if (gridd->type != GRIDDATA_RECTANGULAR_1D && gridd->type != GRIDDATA_RECTANGULAR_2D &&
      gridd->type != GRIDDATA_RECTANGULAR_3D) {
    SETERRQ(PETSC_ERR_ARG_WRONG,1,"Grid not of rectangular type");
  }
  *da = s->da;
  PetscFunctionReturn(0);
}

#undef __FUNC__  
#define __FUNC__ "GridDataRectangularGetXYZ" 
int GridDataRectangularGetXYZ(GridData gridd,double **x,double **y,double **z)
{
  GridData_Rectangular *s = (GridData_Rectangular *) gridd->data;

  PetscFunctionBegin;
  if (gridd->type != GRIDDATA_RECTANGULAR_1D && gridd->type != GRIDDATA_RECTANGULAR_2D &&
      gridd->type != GRIDDATA_RECTANGULAR_3D) {
    SETERRQ(PETSC_ERR_ARG_WRONG,1,"Grid not of rectangular type");
  }
  if (x) *x = s->x;
  if (y) *y = s->y;
  if (z) *z = s->z;
  PetscFunctionReturn(0);
}
