/* $Id: zf90.h,v 1.5 1998/04/25 21:08:21 balay Exp $ */

#if !defined(__ZF90)
#define __ZF90

#include "src/fortran/custom/zpetsc.h"
#if defined(HAVE_IRIXF90)
#include "src/fortran/f90/f90_IRIX.h"
#elif defined(HAVE_XLF90)
#include "src/fortran/f90/f90_rs6000.h"
#elif defined(HAVE_T3EF90)
#include "src/fortran/f90/f90_t3e.h"
#elif defined(HAVE_NAGF90)
#include "/usr/local/lib/f90/f90.h"
#define array1d Dope1
#define array2d Dope2
#define array3d Dope3
#else
#define HAVE_NOF90
#endif

#if !defined (HAVE_NOF90)

extern int PetscF90Create1dArrayScalar(Scalar *,int, array1d *);
extern int PetscF90Get1dArrayScalar(array1d *,Scalar **);
extern int PetscF90Destroy1dArrayScalar(array1d *);

extern int PetscF90Create2dArrayScalar(Scalar *,int,int, array2d *);
extern int PetscF90Get2dArrayScalar(array2d *,Scalar **);
extern int PetscF90Destroy2dArrayScalar(array2d *);

extern int PetscF90Create1dArrayInt(int *,int, array1d *);
extern int PetscF90Get1dArrayInt(array1d *,int **);
extern int PetscF90Destroy1dArrayInt(array1d *);

extern int PetscF90Create1dArrayPetscFortranAddr(PetscFortranAddr *,int, array1d *);
extern int PetscF90Get1dArrayPetscFortranAddr(array1d *,PetscFortranAddr **);
extern int PetscF90Destroy1dArrayPetscFortranAddr(array1d *);

#endif
#endif
