

#ifdef PETSC_RCS_HEADER
static char vcid[] = "$Id: zmat.c,v 1.49 1998/04/21 18:23:47 balay Exp $";
#endif

#include "src/fortran/custom/zpetsc.h"
#include "mat.h"
#include "pinclude/petscfix.h"

#ifdef HAVE_FORTRAN_CAPS
#define matsetvalue_                     MATSETVALUE
#define matgetrow_                       MATGETROW
#define matrestorerow_                   MATRESTOREROW
#define matgetreorderingtypefromoptions_ MATGETREORDERINGTYPEFROMOPTIONS
#define matgettypefromoptions_           MATGETTYPEFROMOPTIONS
#define matgetreordering_                MATGETREORDERING
#define matreorderingregisterall_        MATREORDERINGREGISTERALL
#define matdestroy_                      MATDESTROY
#define matcreatempiaij_                 MATCREATEMPIAIJ
#define matcreateseqaij_                 MATCREATESEQAIJ
#define matcreatempibaij_                MATCREATEMPIBAIJ
#define matcreateseqbaij_                MATCREATESEQBAIJ
#define matcreate_                       MATCREATE
#define matcreateshell_                  MATCREATESHELL
#define matreorderingregisterdestroy_    MATREORDERINGREGISTERDESTROY
#define matcreatempirowbs_               MATCREATEMPIROWBS
#define matcreateseqbdiag_               MATCREATESEQBDIAG
#define matcreatempibdiag_               MATCREATEMPIBDIAG
#define matcreateseqdense_               MATCREATESEQDENSE
#define matcreatempidense_               MATCREATEMPIDENSE
#define matconvert_                      MATCONVERT
#define matload_                         MATLOAD
#define mattranspose_                    MATTRANSPOSE
#define matgetarray_                     MATGETARRAY
#define matrestorearray_                 MATRESTOREARRAY
#define matgettype_                      MATGETTYPE
#define matgetinfo_                      MATGETINFO
#define matshellsetoperation_            MATSHELLSETOPERATION
#define matview_                         MATVIEW
#define matfdcoloringcreate_             MATFDCOLORINGCREATE
#define matfdcoloringdestroy_            MATFDCOLORINGDESTROY
#define matfdcoloringsetfunction_        MATFDCOLORINGSETFUNCTION
#elif !defined(HAVE_FORTRAN_UNDERSCORE)
#define matsetvalue_                     matsetvalue
#define matgetrow_                       matgetrow
#define matrestorerow_                   matrestorerow
#define matview_                         matview
#define matgetinfo_                      matgetinfo
#define matgettype_                      matgettype
#define matgettypefromoptions_           matgettypefromoptions
#define matreorderingregisterall_        matreorderingregisterall
#define matdestroy_                      matdestroy
#define matcreatempiaij_                 matcreatempiaij
#define matcreateseqaij_                 matcreateseqaij
#define matcreatempibaij_                matcreatempibaij
#define matcreateseqbaij_                matcreateseqbaij
#define matcreate_                       matcreate
#define matcreateshell_                  matcreateshell
#define matreorderingregisterdestroy_    matreorderingregisterdestroy
#define matgetreordering_                matgetreordering
#define matcreatempirowbs_               matcreatempirowbs
#define matcreateseqbdiag_               matcreateseqbdiag
#define matcreatempibdiag_               matcreatempibdiag
#define matcreateseqdense_               matcreateseqdense
#define matcreatempidense_               matcreatempidense
#define matconvert_                      matconvert
#define matload_                         matload
#define mattranspose_                    mattranspose
#define matgetarray_                     matgetarray
#define matrestorearray_                 matrestorearray
#define matshellsetoperation_            matshellsetoperation
#define matfdcoloringcreate_             matfdcoloringcreate
#define matfdcoloringdestroy_            matfdcoloringdestroy
#define matfdcoloringsetfunction_        matfdcoloringsetfunction
#endif

#if defined(__cplusplus)
extern "C" {
#endif

void matsetvalue_(Mat mat,int *i,int *j,Scalar *va,InsertMode *mode)
{
  /* cannot use MatSetValue() here since that uses CHKERRQ() which has a return in it */
  MatSetValues((Mat)PetscToPointer(mat),1,i,1,j,va,*mode);
}

void matfdcoloringcreate_(Mat mat,ISColoring iscoloring,MatFDColoring *color,int *__ierr)
{
  MatFDColoring col;

  *__ierr = MatFDColoringCreate((Mat)PetscToPointer(mat),
                                (ISColoring)PetscToPointer(iscoloring),&col);
  *(PetscFortranAddr*) color = PetscFromPointer(col);
}

/*
   This is a poor way of storing the column and value pointers 
  generated by MatGetRow() to be returned with MatRestoreRow()
  but there is not natural, good place else to store them. Hence
  Fortran programmers can only have one outstanding MatGetRows()
  at a time.
*/
static int    matgetrowactive = 0, *my_ocols = 0;
static Scalar *my_ovals = 0;

void matgetrow_(Mat mat,int *row,int *ncols,int *cols,Scalar *vals,int *ierr)
{
  int    **oocols = &my_ocols;
  Scalar **oovals = &my_ovals;

  if (matgetrowactive) {
     PetscError(__LINE__,"MatGetRow_Fortran",__FILE__,__SDIR__,1,0,
               "Cannot have two MatGetRow() active simultaneously\n\
               call MatRestoreRow() before calling MatGetRow() a second time");
     *ierr = 1;
     return;
  }
  if (FORTRANNULLINTEGER(cols)) oocols = PETSC_NULL;
  if (FORTRANNULLSCALAR(vals)) oovals = PETSC_NULL;

  *ierr = MatGetRow((Mat)PetscToPointer(mat),*row,ncols,oocols,oovals); 
  if (*ierr) return;

  if (oocols) PetscMemcpy(cols,my_ocols,(*ncols)*sizeof(int));
  if (oovals) PetscMemcpy(vals,my_ovals,(*ncols)*sizeof(Scalar));
  matgetrowactive = 1;
}

void matrestorerow_(Mat mat,int *row,int *ncols,int *cols,Scalar *vals,int *ierr)
{
  int    **oocols = &my_ocols;
  Scalar **oovals = &my_ovals;
  if (!matgetrowactive) {
     PetscError(__LINE__,"MatRestoreRow_Fortran",__FILE__,__SDIR__,1,0,
               "Must call MatGetRow() first");
     *ierr = 1;
     return;
  }
  if (FORTRANNULLINTEGER(cols)) oocols = PETSC_NULL;
  if (FORTRANNULLSCALAR(vals)) oovals = PETSC_NULL;
  *ierr = MatRestoreRow((Mat)PetscToPointer(mat),*row,ncols,oocols,oovals); 
  matgetrowactive = 0;
}

void matview_(Mat mat,Viewer viewer, int *__ierr )
{
  PetscPatchDefaultViewers_Fortran(viewer);
  *__ierr = MatView((Mat)PetscToPointer(mat),viewer);
}

void matgetinfo_(Mat mat,MatInfoType *flag,double *finfo,int *__ierr ){
  MatInfo info;
  *__ierr = MatGetInfo((Mat)PetscToPointer(mat),*flag,&info);
  finfo[0]  = info.rows_global;
  finfo[1]  = info.columns_global;
  finfo[2]  = info.rows_local;
  finfo[3]  = info.columns_global;
  finfo[4]  = info.block_size;
  finfo[5]  = info.nz_allocated;
  finfo[6]  = info.nz_used;
  finfo[7]  = info.nz_unneeded;
  finfo[8]  = info.memory;
  finfo[9]  = info.assemblies;
  finfo[10] = info.mallocs;
  finfo[11] = info.fill_ratio_given;
  finfo[12] = info.fill_ratio_needed;
  finfo[13] = info.factor_mallocs;
}

  /*
     this next one is TOTALLY wrong, or is it? 
  */
void matgetreorderingtypefromoptions_(CHAR prefix,MatReorderingType *type, 
                                      int *__ierr,int len )
{
  char *t;

  FIXCHAR(prefix,len,t);
  *__ierr = MatGetReorderingTypeFromOptions(t,type);
  FREECHAR(prefix,t);
}

void matgettypefromoptions_(MPI_Comm *comm,CHAR prefix,MatType *type,
                              PetscTruth *set,int *__ierr,int len)
{
  char *t;
  FIXCHAR(prefix,len,t);
  *__ierr = MatGetTypeFromOptions((MPI_Comm)PetscToPointerComm( *comm ),t,type,set);
  FREECHAR(prefix,t);
}


void matgetarray_(Mat mat,Scalar *fa,long *ia, int *__ierr)
{
  Scalar *mm;
  int    m,n;
  Mat    A = (Mat)PetscToPointer(mat);

  *__ierr = MatGetArray(A,&mm); if (*__ierr) return;
  *__ierr = MatGetSize(A,&m,&n);  if (*__ierr) return;
  *__ierr = PetscScalarAddressToFortran((PetscObject)A,fa,mm,m*n,ia); if (*__ierr) return;
}

void matrestorearray_(Mat mat,Scalar *fa,long *ia,int *__ierr)
{
  Mat                  min = (Mat)PetscToPointer(mat);
  Scalar               *lx;
  int                  m,n;

  *__ierr = MatGetSize(min,&m,&n); if (*__ierr) return;
  *__ierr = PetscScalarAddressFromFortran((PetscObject) min,fa,*ia,m*n,&lx);if (*__ierr) return;
  *__ierr = MatRestoreArray(min,&lx);if (*__ierr) return;
}

void mattranspose_(Mat mat,Mat *B, int *__ierr )
{
  Mat mm;
  if (FORTRANNULLINTEGER(B)) B = PETSC_NULL;
  *__ierr = MatTranspose((Mat)PetscToPointer(mat),&mm);
  *(PetscFortranAddr*) B = PetscFromPointer(mm);
}

void matload_(Viewer viewer,MatType *outtype,Mat *newmat, int *__ierr )
{
  Mat mm;
  *__ierr = MatLoad((Viewer)PetscToPointer(viewer),*outtype,&mm);
  *(PetscFortranAddr*) newmat = PetscFromPointer(mm);
}

void matconvert_(Mat mat,MatType *newtype,Mat *M, int *__ierr )
{
  Mat mm;
  *__ierr = MatConvert((Mat)PetscToPointer(mat),*newtype,&mm);
  *(PetscFortranAddr*) M = PetscFromPointer(mm);
}

void matcreateseqdense_(MPI_Comm *comm,int *m,int *n,Scalar *data,Mat *newmat,int *__ierr )
{
  Mat mm;
  if (FORTRANNULLSCALAR(data)) data = PETSC_NULL;
  *__ierr = MatCreateSeqDense((MPI_Comm)PetscToPointerComm(*comm),*m,*n,data,&mm);
  *(PetscFortranAddr*) newmat = PetscFromPointer(mm);
}

void matcreatempidense_(MPI_Comm *comm,int *m,int *n,int *M,int *N,Scalar *data,Mat *newmat,
                        int *__ierr ){
  Mat mm;
  if (FORTRANNULLSCALAR(data)) data = PETSC_NULL;
  *__ierr = MatCreateMPIDense((MPI_Comm)PetscToPointerComm( *comm ),*m,*n,*M,*N,data,&mm);
  *(PetscFortranAddr*) newmat = PetscFromPointer(mm);
}

/* Fortran ignores diagv */
void matcreatempibdiag_(MPI_Comm *comm,int *m,int *M,int *N,int *nd,int *bs,
                        int *diag,Scalar **diagv,Mat *newmat, int *__ierr )
{
  Mat mm;
  *__ierr = MatCreateMPIBDiag((MPI_Comm)PetscToPointerComm( *comm ),
                              *m,*M,*N,*nd,*bs,diag,PETSC_NULL,&mm);
  *(PetscFortranAddr*) newmat = PetscFromPointer(mm);
}

/* Fortran ignores diagv */
void matcreateseqbdiag_(MPI_Comm *comm,int *m,int *n,int *nd,int *bs,
                        int *diag,Scalar **diagv,Mat *newmat, int *__ierr )
{
  Mat mm;
  *__ierr = MatCreateSeqBDiag((MPI_Comm)PetscToPointerComm( *comm ),*m,*n,*nd,*bs,diag,
                               PETSC_NULL,&mm);
  *(PetscFortranAddr*) newmat = PetscFromPointer(mm);
}

/*  Fortran cannot pass in procinfo, hence ignored */
void matcreatempirowbs_(MPI_Comm *comm,int *m,int *M,int *nz,int *nnz,
                       void *procinfo,Mat *newmat, int *__ierr )
{
  Mat mm;
  if (FORTRANNULLINTEGER(nnz)) nnz = PETSC_NULL;
  *__ierr = MatCreateMPIRowbs((MPI_Comm)PetscToPointerComm( *comm ),
                               *m,*M,*nz,nnz,PETSC_NULL,&mm);
  *(PetscFortranAddr*) newmat = PetscFromPointer(mm);
}

void matgetreordering_(Mat mat,MatReorderingType *type,IS *rperm,IS *cperm, 
                       int *__ierr )
{
  IS i1,i2;
  *__ierr = MatGetReordering((Mat)PetscToPointer(mat),*type,&i1,&i2);
  *(PetscFortranAddr*) rperm = PetscFromPointer(i1);
  *(PetscFortranAddr*) cperm = PetscFromPointer(i2);
}

void matreorderingregisterdestroy_(int *__ierr)
{
  *__ierr = MatReorderingRegisterDestroy();
}

void matgettype_(Mat mm,MatType *type,CHAR name,int *__ierr,int len)
{
  char *tname;

  if (FORTRANNULLINTEGER(type)) type = PETSC_NULL;
  *__ierr = MatGetType((Mat)PetscToPointer(mm),type,&tname);
#if defined(USES_CPTOFCD)
  {
  char *t = _fcdtocp(name); int len1 = _fcdlen(name);
  if (t != PETSC_NULL_CHARACTER_Fortran) PetscStrncpy(t,tname,len1);
  }
#else
  if (name != PETSC_NULL_CHARACTER_Fortran) PetscStrncpy(name,tname,len);
#endif
}

void matcreate_(MPI_Comm *comm,int *m,int *n,Mat *V, int *__ierr )
{
  Mat mm;
  *__ierr = MatCreate((MPI_Comm)PetscToPointerComm( *comm),*m,*n,&mm);
  *(PetscFortranAddr*) V = PetscFromPointer(mm);
}

void matcreateseqaij_(MPI_Comm *comm,int *m,int *n,int *nz,
                           int *nnz,Mat *newmat, int *__ierr )
{
  Mat mm;
  if (FORTRANNULLINTEGER(nnz)) nnz = PETSC_NULL;
  *__ierr = MatCreateSeqAIJ((MPI_Comm)PetscToPointerComm(*comm),*m,*n,*nz,nnz,&mm);
  *(PetscFortranAddr*) newmat = PetscFromPointer(mm);
}

void matcreateseqbaij_(MPI_Comm *comm,int *bs,int *m,int *n,int *nz,
                           int *nnz,Mat *newmat, int *__ierr )
{
  Mat mm;
  if (FORTRANNULLINTEGER(nnz)) nnz = PETSC_NULL;
  *__ierr = MatCreateSeqBAIJ((MPI_Comm)PetscToPointerComm(*comm),*bs,*m,*n,*nz,nnz,&mm);
  *(PetscFortranAddr*) newmat = PetscFromPointer(mm);
}

void matfdcoloringdestroy_(MatFDColoring mat, int *__ierr )
{
  *__ierr = MatFDColoringDestroy((MatFDColoring)PetscToPointer(mat));
   PetscRmPointer(mat); 
}

void matdestroy_(Mat mat, int *__ierr )
{
  *__ierr = MatDestroy((Mat)PetscToPointer(mat));
   PetscRmPointer(mat); 
}

void matreorderingregisterall_(int *__ierr)
{
  *__ierr = MatReorderingRegisterAll();
}

void matcreatempiaij_(MPI_Comm *comm,int *m,int *n,int *M,int *N,
         int *d_nz,int *d_nnz,int *o_nz,int *o_nnz,Mat *newmat, int *__ierr )
{
  Mat mm;
  if (FORTRANNULLINTEGER(d_nnz)) d_nnz = PETSC_NULL;
  if (FORTRANNULLINTEGER(o_nnz)) o_nnz = PETSC_NULL;
  *__ierr = MatCreateMPIAIJ((MPI_Comm)PetscToPointerComm(*comm),
                             *m,*n,*M,*N,*d_nz,d_nnz,*o_nz,o_nnz,&mm);
  *(PetscFortranAddr*)newmat = PetscFromPointer(mm);
}
void matcreatempibaij_(MPI_Comm *comm,int *bs,int *m,int *n,int *M,int *N,
         int *d_nz,int *d_nnz,int *o_nz,int *o_nnz,Mat *newmat, int *__ierr )
{
  Mat mm;
  if (FORTRANNULLINTEGER(d_nnz)) d_nnz = PETSC_NULL;
  if (FORTRANNULLINTEGER(o_nnz)) o_nnz = PETSC_NULL;
  *__ierr = MatCreateMPIBAIJ((MPI_Comm)PetscToPointerComm(*comm),
                             *bs,*m,*n,*M,*N,*d_nz,d_nnz,*o_nz,o_nnz,&mm);
  *(PetscFortranAddr*)newmat = PetscFromPointer(mm);
}

/*
      The MatShell Matrix Vector product requires a C routine.
   This C routine then calls the corresponding Fortran routine that was
   set by the user.
*/
void matcreateshell_(MPI_Comm *comm,int *m,int *n,int *M,int *N,void *ctx,Mat *mat, int *__ierr )
{
  Mat mm;
  *__ierr = MatCreateShell((MPI_Comm)PetscToPointerComm(*comm),*m,*n,*M,*N,ctx,&mm);
  if (*__ierr) return;
  ((PetscObject)mm)->fortran_func_pointers = (void **) PetscMalloc(sizeof(void *));
  if (!((PetscObject)mm)->fortran_func_pointers) {*__ierr = 1; return;}
  *(PetscFortranAddr*) mat = PetscFromPointer(mm);
}

static int ourmult(Mat mat, Vec x, Vec y)
{
  int              ierr = 0;
  PetscFortranAddr s1,s2,s3;

  s1 = PetscFromPointer(mat);
  s2 = PetscFromPointer(x);
  s3 = PetscFromPointer(y);
  (*(int (*)(PetscFortranAddr*,PetscFortranAddr*,PetscFortranAddr*,int*))(((PetscObject)mat)->fortran_func_pointers[0]))(&s1,&s2,&s3,&ierr);
  PetscRmPointer(&s3);
  PetscRmPointer(&s2);
  PetscRmPointer(&s1);
  return ierr;
}

void matshellsetoperation_(Mat mat,MatOperation *op,int (*f)(PetscFortranAddr*,PetscFortranAddr*,
                    PetscFortranAddr*,int*), int *__ierr )
{
  Mat mm = (Mat)PetscToPointer(mat);
  if (*op == MATOP_MULT) {
    *__ierr = MatShellSetOperation(mm,*op,(void*) ourmult);
    ((PetscObject)mm)->fortran_func_pointers[0] = (void *) f;
  } else {
    PetscError(__LINE__,"MatShellSetOperation_Fortran",__FILE__,__SDIR__,1,0,
               "Cannot set that matrix operation");
    *__ierr = 0;
  }
}

#include "ts.h"
/*
        MatFDColoringSetFunction sticks the Fortran function into the fortran_func_pointers
    this function is then accessed by ourmatfdcoloringfunction()

   NOTE: FORTRAN USER CANNOT PUT IN A NEW J OR B currently.

   USER CAN HAVE ONLY ONE MatFDCOloring in code Because there is no place to hang f7!
*/

static void (*f7)(PetscFortranAddr*,double*,PetscFortranAddr*,PetscFortranAddr*,void*,int*);

static int ourmatfdcoloringfunctionts(TS ts,double t,Vec x,Vec y, void *ctx)
{
  int              ierr = 0;
  PetscFortranAddr s1,s2,s3;

  s1 = PetscFromPointer(ts);
  s2 = PetscFromPointer(x);
  s3 = PetscFromPointer(y);
  
  (*f7)(&s1,&t,&s2,&s3,ctx,&ierr);

  PetscRmPointer(&s3);
  PetscRmPointer(&s2);
  PetscRmPointer(&s1);

  return ierr;
}

void matfdcoloringsetfunction_(MatFDColoring fd,void (*f)(PetscFortranAddr*,double*,
                PetscFortranAddr*,PetscFortranAddr*,void*,int*),
                               void *ctx, int *__ierr )
{
  MatFDColoring mm = (MatFDColoring)PetscToPointer(fd);
  f7 = f;
  *__ierr = MatFDColoringSetFunction(mm,(int (*)(void))ourmatfdcoloringfunctionts,ctx);
}

#if defined(__cplusplus)
}
#endif
