#ifdef PETSC_RCS_HEADER
static char vcid[] = "$Id: dsflush.c,v 1.17 1998/04/27 14:40:31 curfman Exp $";
#endif
/*
       Provides the calling sequences for all the basic Draw routines.
*/
#include "src/draw/drawimpl.h"  /*I "draw.h" I*/

#undef __FUNC__  
#define __FUNC__ "DrawSynchronizedFlush" 
/*@
   DrawSynchronizedFlush - Flushes graphical output. This waits until all 
   processors have arrived and flushed, then does a global flush.
   This is usually done to change the frame for double buffered graphics.

   Collective on Draw

   Input Parameters:
.  draw - the drawing context

.keywords: draw, sync, flush

@*/
int DrawSynchronizedFlush(Draw draw)
{
  int ierr;
  PetscFunctionBegin;
  PetscValidHeaderSpecific(draw,DRAW_COOKIE);
  if (draw->type == DRAW_NULLWINDOW) PetscFunctionReturn(0);
  if (draw->ops->syncflush) {
    ierr = (*draw->ops->syncflush)(draw);CHKERRQ(ierr);
  }
  PetscFunctionReturn(0);
}
