#include "tools.h"
void pchkmat(m, mpos0, n, npos0, ia, ja, desc_A, apos0, info0, nprow, npcol, 
             myrow, mycol)
int m;
int mpos0;
int n;
int npos0;
int ia;
int ja;
int *desc_A;
int apos0;
int *info0;
int nprow;
int npcol;
int myrow;
int  mycol;
{
#define DESCMULT 100
#define BIGNUM   10000
   int Cnumroc2();

   int info, mpos, npos, iapos, japos, descpos, LOCp;

   info = *info0;
   mpos = mpos0 * DESCMULT;
   npos = npos0 * DESCMULT;
   iapos =  (apos0 - 2) * DESCMULT;
   japos =  (apos0 - 1) * DESCMULT;
   descpos =  apos0 * DESCMULT;

   if (nprow == -1)
   {
      info = -info;
      if (info < DESCMULT) *info0 = -descpos - CTXT_ - 1;
      else if ( (info % DESCMULT) != CTXT_+1 ) *info0 = -descpos - CTXT_ - 1;
      return;
   }
   if (info == 0) info = BIGNUM;
   else if (info < 0) info = -info;
   if (info < DESCMULT) info = info * DESCMULT;
/*
 * Check that matrix values make sense from local viewpoint
 */
   if(desc_A[DT_] != BLOCK_CYCLIC_2D) info = MIN(info, descpos+DT_+1);
   else if (m < 0) info = MIN(info, mpos);
   else if (n < 0) info = MIN(info, npos);
   else if (ia < 1) info = MIN(info, iapos);
   else if (ja < 1) info = MIN(info, japos);
   else if (desc_A[MB_] < 1) info = MIN(info, descpos+MB_+1);
   else if (desc_A[NB_] < 1) info = MIN(info, descpos+NB_+1);
   else if ( (desc_A[RSRC_] < 0) || (desc_A[RSRC_] >= nprow) )
      info = MIN(info, descpos+RSRC_+1);
   else if ( (desc_A[CSRC_] < 0) || (desc_A[CSRC_] >= npcol) )
      info = MIN(info, descpos+CSRC_+1);
   else if (desc_A[LLD_] < 1) info = MIN(info, descpos+LLD_+1);

/*
 * If we have null matrix, relax some checks
 */
   if (n == 0)
   {
      if (desc_A[M_] < 0) info = MIN(info, descpos+M_+1);
      if (desc_A[N_] < 0) info = MIN(info, descpos+N_+1);
      if (desc_A[LLD_] < 1) info = MIN(info, descpos+LLD_+1);
   }
/*
 * More rigorous checks for non-degenerate matrices
 */
   else
   {
      if (desc_A[M_] < 1) info = MIN(info, descpos+M_+1);
      else if (desc_A[N_] < 1) info = MIN(info, descpos+N_+1);
      else if (ia+m-1 > desc_A[M_]) info = MIN(info, iapos);
      else if (ja+n-1 > desc_A[N_]) info = MIN(info, japos);

      if (info == BIGNUM)
      {
         LOCp = Cnumroc2(desc_A[M_], 0, desc_A[MB_], myrow, desc_A[RSRC_],
                         nprow);
         if (LOCp < 1) LOCp = 1;
         if (desc_A[LLD_] < LOCp)
         {
            if ( Cnumroc2(desc_A[N_], 0, desc_A[NB_], mycol, desc_A[CSRC_],
                          npcol) )
               info = descpos+LLD_+1;
         }
      }
   }
/*
 * Prepare output: set info = 0 if there is no error, and divide by DESCMULT if
 * error is not a descriptor entry
 */
   if (info == BIGNUM) *info0 = 0;
   else if (info % DESCMULT == 0) *info0 = -info / DESCMULT;
   else *info0 = -info;
}
