      SUBROUTINE PBZGERC( ICONTXT, XDIST, YDIST, M, N, MB, NB, MZ, NZ,
     $                    ALPHA, X, INCX, Y, INCY, A, LDA, IXROW, IXCOL,
     $                    IYROW, IYCOL, IAROW, IACOL, BR1ST, XCOMM,
     $                    XWORK, YCOMM, YWORK, WORK )
*
*  -- PB-BLAS routine (version 2.1) --
*     University of Tennessee, Knoxville, Oak Ridge National Laboratory.
*     April 28, 1996
*
*     Jaeyoung Choi, Oak Ridge National Laboratory
*     Jack Dongarra, University of Tennessee and Oak Ridge National Lab.
*     David Walker,  Oak Ridge National Laboratory
*
*     .. Scalar Arguments ..
      CHARACTER*1        BR1ST, XCOMM, XDIST, XWORK, YCOMM, YDIST,
     $                   YWORK
      INTEGER            IACOL, IAROW, ICONTXT, INCX, INCY, IXCOL,
     $                   IXROW, IYCOL, IYROW, LDA, M, MB, MZ, N, NB, NZ
      COMPLEX*16         ALPHA
*     ..
*     .. Array Arguments ..
      COMPLEX*16         A( LDA, * ), X( * ), Y( * ), WORK( * )
*     ..
*
*  Purpose
*  =======
*
*  PBZGERC is a parallel blocked version of ZGERC.
*  PBZGERC performs  one of the matrix-vector operations  based on
*  block cyclic distribution.
*
*  PBZGERC performs the rank 1 operation
*
*                        A := alpha*x*conjg( y' ) + A,
*
*  where alpha is a scalar, X is an m element vector, Y is an n element
*  vector and A is an m-by-n matrix.
*
*  Parameters
*  ==========
*
*  ICONTXT (input) INTEGER
*          ICONTXT is the BLACS mechanism for partitioning communication
*          space.  A defining property of a context is that a message in
*          a context cannot be sent or received in another context.  The
*          BLACS context includes the definition of a grid, and each
*          process' coordinates in it.
*
*  XDIST   (input) CHARACTER*1
*          XDIST specifies the distribution of vector X as follows:
*
*             XDIST = 'C',  X is distributed columnwise
*                           or on a column of processes
*             XDIST = 'R',  X is distributed rowwise
*                           or on a row of processes
*
*  YDIST   (input) CHARACTER*1
*          YDIST specifies the distribution of vector Y as follows:
*
*             YDIST = 'C',  Y is distributed columnwise
*                           or on a column of processes
*             YDIST = 'R',  Y is distributed rowwise
*                           or on a row of processes
*
*  M       (input) INTEGER
*          M specifies the number of rows of the matrix A.  M >= 0.
*
*  N       (input) INTEGER
*          N specifies the number of columns of the matrix A.  N >= 0.
*
*  MB      (input) INTEGER
*          MB specifies the column block size of the matrix A and the
*          block size of the vector X.  MB >= 1.
*
*  NB      (input) INTEGER
*          MB specifies the row block size of the matrix A and the
*          block size of the vector Y.  NB >= 1.
*
*  MZ      (input) INTEGER
*          MZ is the column offset to specify the column distance from
*          the beginning of the block to the the first element of A.
*          0 <= MZ < MB.
*
*  NZ      (input) INTEGER
*          NZ is the row offset to specify the row distance from the
*          beginning of the block to the the first element of A.
*          0 <= NZ < NB.
*
*  ALPHA   (input) COMPLEX*16
*          ALPHA specifies the scalar alpha.
*
*  X       (input) COMPLEX*16 array of DIMENSION at least
*          ( 1 + ( Mp - 1 )*abs( INCX ) ) if XDIST = 'C', or
*          ( 1 + ( Mq - 1 )*abs( INCX ) ) if XDIST = 'R'.
*          The incremented array X must contain the (local) vector X.
*
*  INCX    (input) INTEGER
*          INCX specifies the increment for the elements of X.
*          INCX <> 0.
*
*  Y       (input/output) COMPLEX*16 array of DIMENSION at least
*          ( 1 + ( Np - 1 )*abs( INCY ) ) if YDIST = 'C', or.
*          ( 1 + ( Nq - 1 )*abs( INCY ) ) if YDIST = 'R'.
*          The incremented array Y must contain the (local) vector Y.
*
*  INCY    (input) INTEGER
*          INCY specifies the increment for the elements of Y.
*          INCY <> 0.
*
*  A       (input/output) COMPLEX*16 array of DIMENSION ( LDA, Nq ),
*          On entry, the leading Mp-by-Nq part of the array must
*          contain the (local) matrix A.
*          On exit, A is overwritten by the updated matrix.
*
*  LDA     (input) INTEGER
*          The leading dimension of the (local) array A.
*          LDA >= max( 1, Mp ).
*
*  IXROW   (input) INTEGER
*          IXROW specifies a row of the process template which has
*          the first element of X.  0 <= IXROW < NPROW.  If all rows
*          of the process template have their own copies of X when
*          XDIST = 'R', then set IXROW = -1.
*
*  IXCOL   (input) INTEGER
*          IXCOL specifies a column of the process template which has
*          the first element of X.  0 <= IXCOL < NPCOL.  If all columns
*          of the process template have their own copies of X when
*          XDIST = 'C', then set IXCOL = -1.
*
*  IYROW   (input) INTEGER
*          IYROW specifies a row of the process template which has
*          the first element of Y.  0 <= IYROW < NPROW.  If all rows
*          of the process template have their own copies of Y when
*          YDIST = 'R', then set IYROW = -1.
*
*  IYCOL   (input) INTEGER
*          IYCOL specifies a column of the process template which has
*          the first element of Y.  0 <= IYCOL < NPCOL.  If all columns
*          of the process template have their own copies of Y when
*          YDIST = 'C', then set IYCOL = -1.
*
*  IAROW   (input) INTEGER
*          The process row that has the first block of A.
*          0 <= IAROW < NPROW.
*
*  IACOL   (input) INTEGER
*          The process column that has the first block of A.
*          0 <= IACOL < NPCOL.
*
*  BR1ST   (input) CHARACTER*1
*          BR1ST determines which vector needs to be broadcast first,
*          X or Y, when IXCOL >= 0, and IYROW >= 0.
*
*             BR1ST = 'X':  X is broadcast first,
*             BR1ST = 'Y':  Y is broadcast first.
*
*  XCOMM   (input) CHARACTER*1
*          XCOMM specifies the communication scheme of X if XDIST = 'C'.
*          It follows topology definition of BLACS.
*
*  XWORK   (input) CHARACTER*1
*          XWORK determines whether X is a workspace or not.
*
*             XWORK = 'Y':  X is workspace in other processes.
*                           X is sent to X position in other processes.
*                           It is assumed that processes have
*                           sufficient space to store (local) X.
*             XWORK = 'N':  Data of X in other processes will be
*                           untouched (unchanged).
*
*  YCOMM   (input) CHARACTER*1
*          YCOMM specifies the columnwise communication scheme of Y.
*          It follows topology definition of BLACS.
*
*  YWORK   (input) CHARACTER*1
*          YWORK determines whether Y is a workspace or not.
*
*             YWORK = 'Y':  Y is workspace in other processes.
*                           Y is sent to Y position in other processes.
*                           It is assumed that processes have
*                           sufficient space to store (local) Y.
*             YWORK = 'N':  Data of Y in other processes will be
*                           untouched (unchanged).
*
*  WORK    (workspace) COMPLEX*16 array of DIMENSION Size(WORK)
*          It will store copy of X and/or copy of Y. (see requirements)
*
*  Memory Requirement of WORK
*  ==========================
*
*  MM   = M + MZ
*  NN   = N + NZ
*  Mpb  = CEIL( MM, MB*NPROW )
*  Nqb  = CEIL( NN, NB*NPCOL )
*  Mp0  = NUMROC( MM, MB, 0, 0, NPROW ) ~= Mpb * MB
*  Nq0  = NUMROC( NN, NB, 0, 0, NPCOL ) ~= Nqb * NB
*  LCMQ = LCM / NPCOL
*  LCMP = LCM / NPROW
*
*  (1) XDIST='C' & YDIST = 'C'
*     Size(WORK) = Nq0
*                + Mp0                (if IXCOL <> -1 & XWORK <> 'Y')
*                + MAX[ CEIL(Nqb,LCMQ)*NB           (if IYCOL <> -1),
*                       CEIL(Nqb,LCMQ)*NB*MIN(LCMQ,CEIL(NN,NB))
*                                                   (if IYCOL  = -1) ]
*
*  (2) XDIST='C' & YDIST = 'R'
*     Size(WORK) = Mp0                (if IXCOL <> -1 & XWORK <> 'Y')
*                + Nq0                (if IYROW <> -1 & YWORK <> 'Y')
*
*  (3) XDIST='R' & YDIST = 'C'
*     Size(WORK) = Mp0 + Nq0
*                + MAX[ CEIL(Mpb,LCMP)*MB           (if IXROW <> -1),
*                       CEIL(Mpb,LCMP)*MB*MIN(LCMP,CEIL(MM,MB))
*                                                   (if IXROW  = -1) ]
*                + MAX[ CEIL(Nqb,LCMQ)*NB           (if IYCOL <> -1),
*                       CEIL(Nqb,LCMQ)*NB*MIN(LCMQ,CEIL(NN,NB))
*                                                   (if IYCOL  = -1) ]
*
*  (4) XDIST='R' & YDIST = 'R'
*     Size(WORK) = Mp0 + Nq0
*                + Nq0                (if IYROW <> -1 & YWORK <> 'Y')
*                + MAX[ CEIL(Mpb,LCMP)*MB           (if IXROW <> -1),
*                       CEIL(Mpb,LCMP)*MB*MIN(LCMP,CEIL(MM,MB))
*                                                   (if IXROW  = -1) ]
*
*  Notes
*  -----
*  More precise space can be computed as
*
*  CEIL(Mpb,LCMP)*MB => NUMROC( NUMROC(MM,MB,0,0,NPROW), MB, 0, 0, LCMP)
*                    = NUMROC( Mp0, MB, 0, 0, LCMP )
*  CEIL(Nqb,LCMQ)*NB => NUMROC( NUMROC(NN,NB,0,0,NPCOL), NB, 0, 0, LCMQ)
*                    = NUMROC( Nq0, NB, 0, 0, LCMQ )
*
*  =====================================================================
*
*     ..
*     .. Parameters ..
      COMPLEX*16         ONE, ZERO
      PARAMETER          ( ONE  = ( 1.0D+0, 0.0D+0 ),
     $                   ZERO = ( 0.0D+0, 0.0D+0 ) )
*     ..
*     .. Local Scalars ..
      CHARACTER*1        COMMX, COMMY
      LOGICAL            XCOL, XDATA, YCOL, YDATA
      INTEGER            INFO, IPX, IPY, MP, MYCOL, MYROW, NPCOL, NPROW,
     $                   NQ
*     ..
*     .. External Functions ..
      LOGICAL            LSAME
      INTEGER            NUMROC
      EXTERNAL           LSAME, NUMROC
*     ..
*     .. External Subroutines ..
      EXTERNAL           BLACS_GRIDINFO, PBZTRNV, PBZVECADD, PXERBLA,
     $                   ZGEBR2D, ZGEBS2D, ZGERC
*     ..
*     .. Executable Statements ..
*
*     Quick return if possible.
*
      IF( ( M.EQ.0 ).OR.( N.EQ.0 ).OR.( ALPHA.EQ.ZERO ) )
     $   RETURN
*
      CALL BLACS_GRIDINFO( ICONTXT, NPROW, NPCOL, MYROW, MYCOL )
*
      XCOL = LSAME( XDIST, 'C' )
      YCOL = LSAME( YDIST, 'C' )
*
*     Test the input parameters.
*
      INFO = 0
      IF(      .NOT.XCOL .AND. .NOT.LSAME( XDIST, 'R' ) ) THEN
         INFO = 2
      ELSE IF( .NOT.YCOL .AND. .NOT.LSAME( YDIST, 'R' ) ) THEN
         INFO = 3
      ELSE IF( M   .LT.0                                ) THEN
         INFO = 4
      ELSE IF( N   .LT.0                                ) THEN
         INFO = 5
      ELSE IF( MB  .LT.1                                ) THEN
         INFO = 6
      ELSE IF( NB  .LT.1                                ) THEN
         INFO = 7
      ELSE IF( MZ  .LT.0 .OR. MZ .GE. MB                ) THEN
         INFO = 8
      ELSE IF( NZ  .LT.0 .OR. NZ .GE. NB                ) THEN
         INFO = 9
      ELSE IF( INCX.EQ.0                                ) THEN
         INFO = 12
      ELSE IF( INCY.EQ.0                                ) THEN
         INFO = 14
      ELSE IF( IAROW.LT.0 .OR. IAROW.GE.NPROW           ) THEN
         INFO = 21
      ELSE IF( IACOL.LT.0 .OR. IACOL.GE.NPCOL           ) THEN
         INFO = 22
      END IF
*
   10 CONTINUE
      IF( INFO .NE. 0 ) THEN
        CALL PXERBLA( ICONTXT, 'PBZGERC ', INFO )
        RETURN
      END IF
*
*     Initialize parameters
*
      MP = NUMROC( M+MZ, MB, MYROW, IAROW, NPROW )
      IF( MYROW.EQ.IAROW ) MP = MP - MZ
      NQ = NUMROC( N+NZ, NB, MYCOL, IACOL, NPCOL )
      IF( MYCOL.EQ.IACOL ) NQ = NQ - NZ
      COMMX = XCOMM
      IF( LSAME( COMMX, ' ' ) ) COMMX = '1'
      COMMY = YCOMM
      IF( LSAME( COMMY, ' ' ) ) COMMY = '1'
*
      IF( LDA.LT.MAX(1,MP) ) INFO = 16
*
      XDATA = .FALSE.
      YDATA = .FALSE.
*      ___________                                    ___________
*     |           |             ||                   |           |
*     |           |             ||                   |           |
*     |           |             ||   ___________     |           |
*     |     A     |  =  alpha * |X * -----Y-----  +  |     A     |
*     |           |             ||                   |           |
*     |           |             ||                   |           |
*     |___________|             ||                   |___________|
*
*     Broadcast Y columnwise first, then X rowwise
*
      IPX = 1
      IPY = 1
*
      IF( LSAME( BR1ST, 'Y' ) ) THEN
*
*       Broadcast Y to Y or WORK if necessary ( IYROW <> -1 )
*
        IF( YCOL ) THEN
          IF(      IYROW.LT. 0 .OR. IYROW.GE.NPROW ) THEN
            INFO = 19
          ELSE IF( IYCOL.LT.-1 .OR. IYCOL.GE.NPCOL ) THEN
            INFO = 20
          END IF
*
          IPX = NQ + 1
          CALL PBZTRNV( ICONTXT, 'Col', 'T', N, NB, NZ, Y, INCY, ZERO,
     $                  WORK(IPY), 1, IYROW, IYCOL, -1, IACOL,
     $                  WORK(IPX) )
*
        ELSE
          IF( IYROW.LT.-1 .OR. IYROW.GE.NPROW ) THEN
            INFO = 19
          ELSE IF( IYCOL.NE.IACOL             ) THEN
            INFO = 20
          END IF
*
          IF( IYROW.EQ.-1 )  YDATA = .TRUE.
          IF( .NOT.YDATA ) THEN
            IF( LSAME( YWORK, 'Y' ) ) THEN
              IF( MYROW.EQ.IYROW ) THEN
                CALL ZGEBS2D( ICONTXT, 'Col', COMMY, 1, NQ, Y, INCY )
              ELSE
                CALL ZGEBR2D( ICONTXT, 'Col', COMMY, 1, NQ, Y, INCY,
     $                        IYROW, MYCOL )
              END IF
              YDATA = .TRUE.
            ELSE
              IF( MYROW.EQ.IYROW ) THEN
                CALL PBZVECADD( ICONTXT, 'V', NQ, ONE, Y, INCY, ZERO,
     $                          WORK(IPY), 1 )
                CALL ZGEBS2D( ICONTXT, 'Col', COMMY, 1, NQ,
     $                        WORK(IPY), 1 )
              ELSE
                CALL ZGEBR2D( ICONTXT, 'Col', COMMY, 1, NQ,
     $                        WORK(IPY), 1, IYROW, MYCOL )
              END IF
              IPX = NQ + 1
            END IF
          END IF
        END IF
*
*       Broadcast X to X or WORK if necessary ( IXCOL <> -1 )
*
        IF( XCOL ) THEN
          IF( IXROW.NE.IAROW                       ) THEN
            INFO = 17
          ELSE IF( IXCOL.LT.-1 .OR. IXCOL.GE.NPCOL ) THEN
            INFO = 18
          END IF
          IF( IXCOL.EQ.-1 )  XDATA = .TRUE.
*
          IF( .NOT.XDATA ) THEN
            IF( LSAME( XWORK, 'Y' ) ) THEN
              IF( MYCOL.EQ.IXCOL ) THEN
                CALL ZGEBS2D( ICONTXT, 'Row', COMMX, 1, MP, X, INCX )
              ELSE
                CALL ZGEBR2D( ICONTXT, 'Row', COMMX, 1, MP, X, INCX,
     $                        MYROW, IXCOL )
              END IF
              XDATA = .TRUE.
            ELSE
              IF( MYCOL.EQ.IXCOL ) THEN
                CALL PBZVECADD( ICONTXT, 'V', MP, ONE, X, INCX, ZERO,
     $                          WORK(IPX), 1 )
                CALL ZGEBS2D( ICONTXT, 'Row', COMMX, 1, MP,
     $                        WORK(IPX), 1 )
              ELSE
                CALL ZGEBR2D( ICONTXT, 'Row', COMMX, 1, MP,
     $                        WORK(IPX), 1, MYROW, IXCOL )
              END IF
            END IF
          END IF
*
        ELSE
          IF(      IXROW.LT.-1 .OR. IXROW.GE.NPROW ) THEN
            INFO = 17
          ELSE IF( IXCOL.LT. 0 .OR. IXCOL.GE.NPCOL ) THEN
            INFO = 18
          END IF
*
          CALL PBZTRNV( ICONTXT, 'Row', 'T', M, MB, MZ, X, INCX, ZERO,
     $                  WORK(IPX), 1, IXROW, IXCOL, IAROW, -1,
     $                  WORK(MP+IPX) )
        END IF
*
*     Broadcast X rowwise first, then Y columnwise
*
      ELSE
*
*       Broadcast X to X or WORK if necessary ( IXCOL <> -1 )
*
        IF( XCOL ) THEN
          IF( IXROW.NE.IAROW                       ) THEN
            INFO = 17
          ELSE IF( IXCOL.LT.-1 .OR. IXCOL.GE.NPCOL ) THEN
            INFO = 18
          END IF
          IF( IXCOL.EQ.-1 )  XDATA = .TRUE.
*
          IF( .NOT.XDATA ) THEN
            IF( LSAME( XWORK, 'Y' ) ) THEN
              IF( MYCOL.EQ.IXCOL ) THEN
                CALL ZGEBS2D( ICONTXT, 'Row', COMMX, 1, MP, X, INCX )
              ELSE
                CALL ZGEBR2D( ICONTXT, 'Row', COMMX, 1, MP, X, INCX,
     $                        MYROW, IXCOL )
              END IF
              XDATA = .TRUE.
            ELSE
              IF( MYCOL.EQ.IXCOL ) THEN
                CALL PBZVECADD( ICONTXT, 'V', MP, ONE, X, INCX, ZERO,
     $                          WORK(IPX), 1 )
                CALL ZGEBS2D( ICONTXT, 'Row', COMMX, 1, MP,
     $                        WORK(IPX), 1 )
              ELSE
                CALL ZGEBR2D( ICONTXT, 'Row', COMMX, 1, MP,
     $                        WORK(IPX), 1, MYROW, IXCOL )
              END IF
              IPY = MP + 1
            END IF
          END IF
        ELSE
          IF(      IXROW.LT.-1 .OR. IXROW.GE.NPROW ) THEN
            INFO = 17
          ELSE IF( IXCOL.LT. 0 .OR. IXCOL.GE.NPCOL ) THEN
            INFO = 18
          END IF
*
          IPY = MP + 1
          CALL PBZTRNV( ICONTXT, 'Row', 'T', M, MB, MZ, X, INCX, ZERO,
     $                  WORK(IPX), 1, IXROW, IXCOL, IAROW, -1,
     $                  WORK(IPY) )
        END IF
*
*       Broadcast Y to Y or WORK if necessary ( IYROW <> -1 )
*
        IF( YCOL ) THEN
          IF(      IYROW.LT. 0 .OR. IYROW.GE.NPROW ) THEN
            INFO = 19
          ELSE IF( IYCOL.LT.-1 .OR. IYCOL.GE.NPCOL ) THEN
            INFO = 20
          END IF
*
          CALL PBZTRNV( ICONTXT, 'Col', 'T', N, NB, NZ, Y, INCY, ZERO,
     $                  WORK(IPY), 1, IYROW, IYCOL, -1, IACOL,
     $                  WORK(IPY+NQ) )
*
        ELSE
          IF( IYROW.LT.-1 .OR. IYROW.GE.NPROW ) THEN
            INFO = 19
          ELSE IF( IYCOL.NE.IACOL             ) THEN
            INFO = 20
          END IF
*
          IF( IYROW.EQ.-1 )  YDATA = .TRUE.
          IF( .NOT.YDATA ) THEN
            IF( LSAME( YWORK, 'Y' ) ) THEN
              IF( MYROW.EQ.IYROW ) THEN
                CALL ZGEBS2D( ICONTXT, 'Col', COMMY, 1, NQ, Y, INCY )
              ELSE
                CALL ZGEBR2D( ICONTXT, 'Col', COMMY, 1, NQ, Y, INCY,
     $                        IYROW, MYCOL )
              END IF
              YDATA = .TRUE.
            ELSE
              IF( MYROW.EQ.IYROW ) THEN
                CALL PBZVECADD( ICONTXT, 'V', NQ, ONE, Y, INCY, ZERO,
     $                          WORK(IPY), 1 )
                CALL ZGEBS2D( ICONTXT, 'Col', COMMY, 1, NQ,
     $                        WORK(IPY), 1 )
              ELSE
                CALL ZGEBR2D( ICONTXT, 'Col', COMMY, 1, NQ,
     $                        WORK(IPY), 1, IYROW, MYCOL )
              END IF
            END IF
          END IF
        END IF
      END IF
*
      IF( INFO.NE.0 ) GO TO 10
*
*     Compute A
*
      IF( XDATA ) THEN
        IF( YDATA ) THEN
          CALL ZGERC( MP, NQ, ALPHA, X, INCX, Y, INCY, A, LDA )
        ELSE
          CALL ZGERC( MP, NQ, ALPHA, X, INCX, WORK(IPY), 1, A, LDA )
        END IF
      ELSE
        IF( YDATA ) THEN
          CALL ZGERC( MP, NQ, ALPHA, WORK(IPX), 1, Y, INCY, A, LDA )
        ELSE
          CALL ZGERC( MP, NQ, ALPHA, WORK(IPX), 1, WORK(IPY), 1,
     $                A, LDA )
        END IF
      END IF
*
      RETURN
*
*     End of PBZGERC
*
      END
