      SUBROUTINE PBZLACP1( ICONTXT, UPLO, FORM, DIAG, M, N, NZ, A, LDA,
     $                     B, LDB, MINT, NINT, MEN, NEN )
*
*  -- PB-BLAS routine (version 2.1) --
*     University of Tennessee, Knoxville, Oak Ridge National Laboratory.
*     April 28, 1996
*
*     .. Scalar Arguments ..
      CHARACTER*1        UPLO, FORM, DIAG
      INTEGER            ICONTXT, LDA, LDB, M, MEN, MINT, N, NEN, NINT,
     $                   NZ
*     ..
*     .. Array Arguments ..
      COMPLEX*16         A( LDA, * ), B( LDB, * )
*     ..
*
*  Purpose
*  =======
*
*  PBZLACP1 copies part of a two-dimensional upper (or lower) triangular
*  matrix A to another matrix B with forced zeros in the other part.
*
*  =====================================================================
*
*     .. Parameters ..
      COMPLEX*16         ONE, ZERO
      PARAMETER          ( ONE  = ( 1.0D+0, 0.0D+0 ),
     $                   ZERO = ( 0.0D+0, 0.0D+0 ) )
*     ..
*     .. Local Scalars ..
      LOGICAL            NOUNIT
      INTEGER            I, J, JJ, JP, KZ, MN, MX
      COMPLEX*16         DUMMY
*     ..
*     .. External Functions ..
      LOGICAL            LSAME
      INTEGER            ICEIL
      EXTERNAL           ICEIL, LSAME
*     ..
*     .. External Subroutines ..
      EXTERNAL           PBZMATADD, PBZVECADD, ZCOPY
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          DBLE, MIN
*     ..
*     .. Executable Statements ..
*
      NOUNIT = LSAME( DIAG, 'N' )
      JP = 0
      MN = M
*
      IF( LSAME( UPLO, 'U' ) ) THEN
*
         IF( LSAME( FORM, 'T' ) ) THEN
*
*           A is upper triangular
*
            DO 10 J = 1, MIN( N-NZ, NEN-JP )
               JJ = JP + J
               MX = MN + J
               IF( NOUNIT ) THEN
                  CALL ZCOPY( MX, A( 1, JJ ), 1, B( 1, JJ ), 1 )
               ELSE
                  CALL ZCOPY( MX-1, A( 1, JJ ), 1, B( 1, JJ ), 1 )
                  B( MX, JJ ) = ONE
               END IF
               CALL PBZVECADD( ICONTXT, 'G', MEN-MX, ZERO, DUMMY, 1,
     $                         ZERO, B( MX+1, JJ ), 1 )
   10       CONTINUE
            MN = MN + MINT - NZ
            JP = JP + NINT - NZ
*
            DO 30 I = 2, ICEIL( NEN+NZ, NINT )
               DO 20 J = 1, MIN( N, NEN-JP )
                  JJ = JP + J
                  MX = MN + J
                  IF( NOUNIT ) THEN
                     CALL ZCOPY( MX, A( 1, JJ ), 1, B( 1, JJ ), 1 )
                  ELSE
                     CALL ZCOPY( MX-1, A( 1, JJ ), 1, B( 1, JJ ), 1 )
                     B( MX, JJ ) = ONE
                  END IF
                  CALL PBZVECADD( ICONTXT, 'G', MEN-MX, ZERO, DUMMY, 1,
     $                            ZERO, B( MX+1, JJ ), 1 )
   20          CONTINUE
               MN = MN + MINT
               JP = JP + NINT
   30       CONTINUE
*
         ELSE IF( LSAME( FORM, 'H' ) ) THEN
*
*           A is upper triangular Hermitian
*
            DO 40 J = 1, MIN( N-NZ, NEN-JP )
               JJ = JP + J
               MX = MN + J
               CALL ZCOPY( MX-1, A( 1, JJ ), 1, B( 1, JJ ), 1 )
               IF( NOUNIT ) THEN
                  B( MX, JJ ) = DBLE( A( MX, JJ ) )
               ELSE
                  B( MX, JJ ) = ONE
               END IF
               CALL PBZVECADD( ICONTXT, 'G', MEN-MX, ZERO, DUMMY, 1,
     $                         ZERO, B( MX+1, JJ ), 1 )
   40       CONTINUE
            MN = MN + MINT - NZ
            JP = JP + NINT - NZ
*
            DO 60 I = 2, ICEIL( NEN+NZ, NINT )
               DO 50 J = 1, MIN( N, NEN-JP )
                  JJ = JP + J
                  MX = MN + J
                  CALL ZCOPY( MX-1, A( 1, JJ ), 1, B( 1, JJ ), 1 )
                  IF( NOUNIT ) THEN
                     B( MX, JJ ) = DBLE( A( MX, JJ ) )
                  ELSE
                     B( MX, JJ ) = ONE
                  END IF
                  CALL PBZVECADD( ICONTXT, 'G', MEN-MX, ZERO, DUMMY, 1,
     $                            ZERO, B( MX+1, JJ ), 1 )
   50          CONTINUE
               MN = MN + MINT
               JP = JP + NINT
   60       CONTINUE
*
         ELSE
*
*           A is a rectangular matrix
*
            KZ = NZ
            DO 70 I = 1, ICEIL( NEN+NZ, NINT )
               MX = MIN( N-KZ, NEN-JP )
               CALL PBZMATADD( ICONTXT, 'V', MN, MX, ONE, A( 1, JP+1 ),
     $                         LDA, ZERO, B( 1, JP+1 ), LDB )
               CALL PBZMATADD( ICONTXT, 'G', MEN-MN, MX, ZERO, DUMMY, 1,
     $                         ZERO, B( MN+1, JP+1 ), LDB )
               MN = MN + MINT
               JP = JP + NINT - KZ
               KZ = 0
   70       CONTINUE
         END IF
*
      ELSE
*
         IF( LSAME( FORM, 'T' ) ) THEN
*
*           A is lower triangular
*
            MN = M - 1
            DO 80 J = 1, MIN( N-NZ, NEN-JP )
               JJ = JP + J
               MX = MN + J
               CALL PBZVECADD( ICONTXT, 'G', MX, ZERO, DUMMY, 1, ZERO,
     $                         B( 1, JJ ), 1 )
               IF( NOUNIT ) THEN
                  CALL ZCOPY( MEN-MX, A( MX+1, JJ ), 1, B( MX+1, JJ ),
     $                        1 )
               ELSE
                  B( MX+1, JJ ) = ONE
                  CALL ZCOPY( MEN-MX-1, A( MX+2, JJ ),1, B( MX+2, JJ ),
     $                        1 )
               END IF
   80       CONTINUE
            MN = MN + MINT - NZ
            JP = JP + NINT - NZ
*
            DO 100 I = 2, ICEIL( NEN+NZ, NINT )
               DO 90 J = 1, MIN( N, NEN-JP )
                  JJ = JP + J
                  MX = MN + J
                  CALL PBZVECADD( ICONTXT, 'G', MX, ZERO, DUMMY, 1,
     $                            ZERO, B( 1, JJ ), 1 )
                  IF( NOUNIT ) THEN
                     CALL ZCOPY( MEN-MX, A( MX+1, JJ ), 1,
     $                           B( MX+1, JJ ), 1 )
                  ELSE
                     B( MX+1, JJ ) = ONE
                     CALL ZCOPY( MEN-MX-1, A( MX+2, JJ ), 1,
     $                           B( MX+2, JJ ), 1 )
                  END IF
   90          CONTINUE
               MN = MN + MINT
               JP = JP + NINT
  100       CONTINUE
*
         ELSE IF( LSAME( FORM, 'H' ) ) THEN
*
*           A is lower triangular Hermitian
*
            MN = M - 1
            DO 110 J = 1, MIN( N-NZ, NEN-JP )
               JJ = JP + J
               MX = MN + J
               CALL PBZVECADD( ICONTXT, 'G', MX, ZERO, DUMMY, 1, ZERO,
     $                         B( 1, JJ ), 1 )
               IF( NOUNIT ) THEN
                  B( MX+1, JJ ) = DBLE( A( MX+1, JJ ) )
               ELSE
                  B( MX+1, JJ ) = ONE
               END IF
               CALL ZCOPY( MEN-MX-1, A( MX+2, JJ ),1, B( MX+2, JJ ), 1 )
  110       CONTINUE
            MN = MN + MINT - NZ
            JP = JP + NINT - NZ
*
            DO 130 I = 2, ICEIL( NEN+NZ, NINT )
               DO 120 J = 1, MIN( N, NEN-JP )
                  JJ = JP + J
                  MX = MN + J
                  CALL PBZVECADD( ICONTXT, 'G', MX, ZERO, DUMMY, 1,
     $                            ZERO, B( 1, JJ ), 1 )
                  IF( NOUNIT ) THEN
                     B( MX+1, JJ ) = DBLE( A( MX+1, JJ ) )
                  ELSE
                     B( MX+1, JJ ) = ONE
                  END IF
                  CALL ZCOPY( MEN-MX-1, A( MX+2, JJ ), 1, B( MX+2, JJ ),
     $                             1 )
  120          CONTINUE
               MN = MN + MINT
               JP = JP + NINT
  130       CONTINUE
*
         ELSE
*
*           A is a rectangular matrix
*
            KZ = NZ
            DO 140 I = 1, ICEIL( NEN+NZ, NINT )
               MX = MIN( N-KZ, NEN-JP )
               CALL PBZMATADD( ICONTXT, 'G', MN, MX, ZERO, DUMMY, 1,
     $                         ZERO, B( 1, JP+1 ), LDB )
               CALL PBZMATADD( ICONTXT, 'V', MEN-MN, MX, ONE,
     $                         A( MN+1, JP+1 ), LDA, ZERO,
     $                         B( MN+1, JP+1 ), LDB )
               MN = MN + MINT
               JP = JP + NINT - KZ
               KZ = 0
  140       CONTINUE
         END IF
      END IF
*
      RETURN
*
*     End of PBZLACP1
*
      END
