      SUBROUTINE PBSSYMV( ICONTXT, UPLO, XYDIST, N, NB, NZ, ALPHA, A,
     $                    LDA, X, INCX, BETA, Y, INCY, IAROW, IACOL,
     $                    IXPOS, IYPOS, XWORK, YWORK, MULLEN, WORK )
*
*  -- PB-BLAS routine (version 2.1) --
*     University of Tennessee, Knoxville, Oak Ridge National Laboratory.
*     April 28, 1996
*
*     Jaeyoung Choi, Oak Ridge National Laboratory
*     Jack Dongarra, University of Tennessee and Oak Ridge National Lab.
*     David Walker,  Oak Ridge National Laboratory
*
*     .. Scalar Arguments ..
      CHARACTER*1        UPLO, XWORK, XYDIST, YWORK
      INTEGER            IACOL, IAROW, ICONTXT, INCX, INCY, IXPOS,
     $                   IYPOS, LDA, MULLEN, N, NB, NZ
      REAL               ALPHA, BETA
*     ..
*     .. Array Arguments ..
      REAL               A( LDA, * ), X( * ), Y( * ), WORK( * )
*
*  Purpose
*  =======
*
*  PBSSYMV  is a parallel blocked version of SSYMV.
*  PBSSYMV  performs  the matrix-vector operations
*
*     Y := alpha*A*X + beta*Y,
*
*  where A = A**T, alpha and beta are scalars, X and Y are N vectors and
*  A is an N-by-N symmetric matrix.
*
*  The first elements of the matrices A is located  in the middle of the
*  first block ((NZ+1,NZ+1) position) and elements of X and Y start from
*  the (NZ+1)-th positions.
*  X is broadcast if necessary, and Y is collected.
*
*  Parameters
*  ==========
*
*  ICONTXT (input) INTEGER
*          ICONTXT is the BLACS mechanism for partitioning communication
*          space.  A defining property of a context is that a message in
*          a context cannot be sent or received in another context.  The
*          BLACS context includes the definition of a grid, and each
*          process' coordinates in it.
*
*  UPLO    (input) CHARACTER*1
*          UPLO specifies whether the upper or lower triangular part of
*          the symmetric matrix A is to be referenced as follows:
*          referenced as follows:
*
*             UPLO = 'U',  Only the upper triangular part of the
*                          symmetric matrix is to be referenced.
*             UPLO = 'L',  Only the lower triangular part of the
*                          symmetric matrix is to be referenced.
*
*  XYDIST  (input) CHARACTER*1
*          XYDIST specifies the distribution of vectors x and y
*          as follows:
*
*             XYDIST = 'C',  x and y are distributed columnwise
*                            or on a column of processes
*             XYDIST = 'R',  x and y are distributed rowwise
*                            or on a row of processes
*
*  N       (input) INTEGER
*          N specifies the (global) number of row and columns
*          of the matrix A.  N >= 0.
*
*  NB      (input) INTEGER
*          NB specifies the block size of matrix A.  It also specifies
*          the block size of the vectors X and Y. NB >= 1.
*
*  NZ      (input) INTEGER
*          NZ is the row and column offset number to specify the row
*          and column distance  from the beginning of the block to the
*          first element of A.  0 <= NZ < NB.
*
*  ALPHA   (input) REAL
*          ALPHA specifies the scalar alpha.
*
*  A       (input) REAL array of DIMENSION ( LDA, Nq ),
*          Before entry, the N-by-N  part of the (global) array A  must
*          contain the symmetric matrix, such that  when UPLO = 'U',
*          the leading N-by-N upper triangular part of the array A
*          must contain the upper triangular part of the symmetric
*          matrix and the strictly lower triangular part of  A  is not
*          referenced,  and when  UPLO = 'L', the leading N-by-N
*          lower triangular part of the array A must contain the lower
*          triangular part  of the symmetric matrix and the strictly
*          upper triangular part of A is not referenced.
*
*  LDA     (input) INTEGER
*          LDA specifies the leading dimension of (local) A as declared
*          the calling (sub) program.  LDA >= MAX(1,Np).
*
*  X       (input) REAL array of DIMENSION at least
*          ( 1  + ( Np - 1 ) * abs( INCX ) ) if XYDIST = 'C', or
*          ( 1  + ( Nq - 1 ) * abs( INCX ) ) if XYDIST = 'R'.
*          The incremented array X must contain the vector X.
*
*  INCX    (input) INTEGER
*          INCX specifies the increment for the elements of X.
*          INCX <> 0.
*
*  BETA    (input) REAL
*          BETA specifies the scalar beta.  When  BETA  is supplied as
*          zero then C need not be set on input.
*
*  Y       (input/output) REAL array of DIMENSION at least
*          ( 1  + ( Np - 1 ) * abs( INCY ) ) if XYDIST = 'C', or
*          ( 1  + ( Nq - 1 ) * abs( INCY ) ) if XYDIST = 'R',
*          On entry with BETA non-zero, the incremented array Y must
*          contain the vector Y.
*          On exit, Y is overwritten by the updated vector Y.
*
*  INCY    (input) INTEGER
*          INCY specifies the increment for the elements of Y.
*          INCY <> 0.
*
*  IAROW   (input) INTEGER
*          IAROW specifies a row of the process template, which holds
*          the first block of the matrix A.  0 <= IAROW < NPROW.
*
*  IACOL   (input) INTEGER
*          IACOL specifies a column of the process template, which
*          holds the first block of the matrix A.  0 <= IACOL < NPCOL.
*
*  IXPOS   (input) INTEGER
*          If XYDIST = 'C', IXPOS specifies a column of the process
*          template which holds the vector X.  If XYDIST = 'R', IXPOS
*          specifies a row of the procesors template which holds the
*          vector X.  If all columns or rows of the template have their
*          own copies of X, set IXPOS = -1.
*          -1 <= IXPOS < NPCOL if XYDIST = 'C', and -1 <= IXPOS < NPROW
*          if XYDIST = 'R'.
*
*  IYPOS   (input) INTEGER
*          If XYDIST = 'C', IYPOS specifies a column of the process
*          template which holds the vector Y.  If XYDIST = 'R', IYPOS
*          specifies a row of the process template which holds the
*          vector Y.
*          -1 <= IYPOS < NPCOL if XYDIST = 'C', and -1 <= IYPOS < NPROW
*          if XYDIST = 'R'.
*
*  XWORK   (input) CHARACTER*1
*          XWORK determines whether X is a workspace or not.
*
*             XWORK = 'Y':  X is workspace in other processes.
*                           X is sent to X position in other processes.
*                           It is assumed that processes have
*                           sufficient space to store (local) X.
*             XWORK = 'N':  Data of X in other processes will be
*                           untouched (unchanged).
*
*  YWORK   (input) CHARACTER*1
*          YWORK determines whether Y is a workspace or not.
*
*             YWORK = 'Y':  Y is workspace in other processes.
*                           It is assumed that processes have
*                           sufficient space to store temporary
*                           (local) Y.
*             YWORK = 'N':  Data of X in  other processes will be
*                           untouched (unchanged).
*
*  MULLEN  (input) INTEGER
*          It specifies  multiplication  length  of the  optimum column
*          number of A  for multiplying A with x.  The value depends on
*          machine characteristics.
*
*  WORK    (workspace) REAL array of dimension Size(WORK).
*          It will store copy of x, y and/or partial A.
*
*  Parameters Details
*  ==================
*
*  Nx      It is a local portion  of N owned by a process, where x is
*          replaced by  either p (=NPROW) or q (=NPCOL)).  The value is
*          determined by N, NB, NZ, x, and MI, where NB is a block size.
*          NZ is a offset from the beginning of the block,  and MI is a
*          row or column position  in a process template. Nx is equal
*          to  or less than Nx0 = CEIL( N+NZ, NB*x ) * NB.
*
*  Communication Scheme
*  ====================
*
*  The communication schemes of the routine are fixed as fan-out and
*  fan-in schemes (COMM = '1-tree', for details, see BLACS user's guide)
*
*  Memory Requirement of WORK
*  ==========================
*
*  NN     = N + NZ
*  Npb    = CEIL( NN, NB*NPROW )
*  Nqb    = CEIL( NN, NB*NPCOL )
*  Np0    = NUMROC( NN, NB, 0, 0, NPROW ) ~= Npb * NB
*  Nq0    = NUMROC( NN, NB, 0, 0, NPCOL ) ~= Nqb * NB
*  LCMP   = LCM / NPROW
*  LCMQ   = LCM / NPCOL
*  ISZCMP = CEIL(MULLEN, LCMQ*NB)
*  SZCMP  = ISZCMP * ISZCMP * LCMQ*NB * LCMP*NB
*
*  (1) XYDIST = 'C'
*     Size(WORK) = 2 * Nq0
*                + Np0                          ( if YWORK <> 'Y' )
*                + Np0          ( if IXPOS <> -1 and XWORK <> 'Y' )
*                + MAX[ SZCMP,
*                       CEIL(Nqb,LCMQ)*NB*MIN(LCMQ,CEIL(NN,NB)) ]
*
*  (2) XYDIST = 'R'
*     Size(WORK) = 2 * Np0
*                + Nq0                          ( if YWORK <> 'Y' )
*                + Nq0          ( if IXPOS <> -1 and XWORK <> 'Y' )
*                + MAX[ SZCMP,
*                       CEIL(Npb,LCMP)*NB*MIN(LCMP,CEIL(NN,NB)) ]
*
*  Notes
*  -----
*  More precise space can be computed as
*
*  CEIL(Npb,LCMP)*NB => NUMROC( NUMROC(NN,NB,0,0,NPROW), NB, 0, 0, LCMP)
*                    = NUMROC( Np0, NB, 0, 0, LCMP )
*  CEIL(Nqb,LCMQ)*NB => NUMROC( NUMROC(NN,NB,0,0,NPCOL), NB, 0, 0, LCMQ)
*                    = NUMROC( Nq0, NB, 0, 0, LCMQ )
*
*  =====================================================================
*
*     .. Parameters ..
      REAL               ONE,          ZERO
      PARAMETER          ( ONE = 1.0E+0, ZERO = 0.0E+0 )
*     ..
*     .. Local Scalars ..
      CHARACTER*1        FORM
      LOGICAL            COLUMN, UPPER, XDATA, YDATA
      INTEGER            INFO, IPBZ, IPT, IPW, IPX, IPY, IPZ, IQBZ,
     $                   ISZCMP, IZ, JJ, JNPBZ, JNQBZ, JPBZ, JQBZ, JZ,
     $                   KI, KIZ, KJ, KJZ, KZ, LCM, LCMP, LCMQ, LDW,
     $                   LMW, LNW, LPBZ, LQBZ, MRCOL, MRROW, MYCOL,
     $                   MYROW, MZCOL, MZROW, NN, NP, NPCOL, NPROW, NQ
      REAL               DUMMY
*     ..
*     .. External Functions ..
      LOGICAL            LSAME
      INTEGER            ICEIL, ILCM, NUMROC
      EXTERNAL           ICEIL, ILCM, LSAME, NUMROC
*     ..
*     .. External Subroutines ..
      EXTERNAL           BLACS_GRIDINFO, PBSDZRO1, PBSLACP1, PBSTRNV,
     $                   PBSVECADD, PXERBLA, SGEBR2D, SGEBS2D, SGEMV,
     $                   SGSUM2D
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          MAX, MIN
*     ..
*     .. Executable Statements ..
*
*     Quick return if possible.
*
      IF( N.EQ.0 .OR. ( ALPHA.EQ.ZERO .AND. BETA.EQ.ONE ) )
     $  RETURN
*
      CALL BLACS_GRIDINFO( ICONTXT, NPROW, NPCOL, MYROW, MYCOL )
*
      UPPER  = LSAME( UPLO,   'U' )
      COLUMN = LSAME( XYDIST, 'C' )
*
*     Test the input parameters.
*
      INFO = 0
      IF( ( .NOT.UPPER ) .AND.
     $    ( .NOT.LSAME( UPLO, 'L' ) )         ) THEN
        INFO = 2
      ELSE IF( ( .NOT.COLUMN              ).AND.
     $         ( .NOT.LSAME( XYDIST, 'R') )   ) THEN
        INFO = 3
      ELSE IF( N  .LT.0                       ) THEN
        INFO = 4
      ELSE IF( NB .LT.0                       ) THEN
        INFO = 5
      ELSE IF( NZ .LT.0 .OR. NZ.GE.NB         ) THEN
        INFO = 6
      ELSE IF( INCX.EQ.0                      ) THEN
        INFO = 11
      ELSE IF( INCY.EQ.0                      ) THEN
        INFO = 14
      ELSE IF( IAROW.LT.0 .OR. IAROW.GE.NPROW ) THEN
        INFO = 15
      ELSE IF( IACOL.LT.0 .OR. IACOL.GE.NPCOL ) THEN
        INFO = 16
      END IF
*
   10 CONTINUE
      IF( INFO .NE. 0 ) THEN
        CALL PXERBLA( ICONTXT, 'PBSSYMV ', INFO )
        RETURN
      END IF
*
*     Start the operations.
*
      NN = N + NZ
      NP = NUMROC( NN, NB, MYROW, IAROW, NPROW )
      IF( MYROW .EQ. IAROW ) NP = NP - NZ
      NQ = NUMROC( NN, NB, MYCOL, IACOL, NPCOL )
      IF( MYCOL .EQ. IACOL ) NQ = NQ - NZ
*
*     Quick return if alpha = zero
*
      IF( ALPHA .EQ. ZERO ) THEN
        IF( COLUMN .AND. MYCOL.EQ.IYPOS ) THEN
          CALL PBSVECADD( ICONTXT, 'V', NP, ZERO, DUMMY, 1, BETA,
     $                    Y, INCY )
        ELSE IF( LSAME( XYDIST, 'R' ) .AND. MYROW.EQ.IYPOS ) THEN
          CALL PBSVECADD( ICONTXT, 'G', NQ, ZERO, DUMMY, 1, BETA,
     $                    Y, INCY )
        END IF
        RETURN
      END IF
*
      IZ = 0
      IF( MYROW .EQ. IAROW ) IZ = NZ
      JZ = 0
      IF( MYCOL .EQ. IACOL ) JZ = NZ
      KZ = 0
*
*     LCM : the least common multiple of NPROW and NPCOL
*
      LCM  = ILCM( NPROW, NPCOL )
      LCMP = LCM  / NPROW
      LCMQ = LCM  / NPCOL
      LPBZ = LCMP * NB
      LQBZ = LCMQ * NB
*
      MRROW = MOD( NPROW+MYROW-IAROW, NPROW )
      MRCOL = MOD( NPCOL+MYCOL-IACOL, NPCOL )
      XDATA = .FALSE.
      IF( IXPOS .EQ. -1 ) XDATA = .TRUE.
      YDATA = .FALSE.
      IF( LDA .LT. MAX(1,NP) ) INFO = 9
*
*     PART 1: Distribute a vector X and its transpose X'
*     ==================================================
*
*     If X and Y are distributed columnwise (in a column of processes)
*
      IF( COLUMN ) THEN
*       Form  y := alpha*A*x + beta*y
*                       _____________
*         ||           |\_           |    ||          ||
*         ||           |  \_         |    ||          ||
*         ||           |    \_       |    ||          ||
*        (x) = alpha * |      A_     | * (x) + beta * (y)
*         ||           |        \_   |    ||          ||
*         ||           |          \_ |    ||          ||
*         ||           |____________\|    ||          ||
*
        IF(      IXPOS.LT.-1 .OR. IXPOS.GE.NPCOL ) THEN
          INFO = 17
        ELSE IF( IYPOS.LT.0  .OR. IYPOS.GE.NPCOL ) THEN
          INFO = 18
        END IF
        IF( INFO .NE. 0 ) GO TO 10
*
*       Initialize parameters
*
        IF( LSAME( YWORK, 'Y' ) ) THEN
          IPZ = 1
          YDATA = .TRUE.
          IF( MYCOL .EQ. IYPOS ) THEN
            CALL PBSVECADD( ICONTXT, 'G', NP, ZERO, DUMMY, 1, BETA,
     $                      Y, INCY )
          ELSE
            CALL PBSVECADD( ICONTXT, 'G', NP, ZERO, DUMMY, 1, ZERO,
     $                      Y, INCY )
          END IF
        ELSE
          IPY = 1
          IPZ = NP + IPY
          CALL PBSVECADD( ICONTXT, 'G', NP, ZERO, DUMMY, 1, ZERO,
     $                    WORK(IPY), 1 )
        END IF
*
        CALL PBSVECADD( ICONTXT, 'G', NQ, ZERO, DUMMY, 1, ZERO,
     $                  WORK(IPZ), 1 )
*
        IPT = NQ + IPZ
        IPX = NQ + IPT
        IPW = NP + IPX
*
*       Broadcast X if necessary
*
        IF( .NOT. XDATA ) THEN
          IF( LSAME( XWORK, 'Y' ) ) THEN
            IF( MYCOL .EQ. IXPOS ) THEN
              CALL SGEBS2D( ICONTXT, 'Row', '1-tree', 1, NP, X, INCX )
            ELSE
              CALL SGEBR2D( ICONTXT, 'Row', '1-tree', 1, NP, X, INCX,
     $                      MYROW, IXPOS )
            END IF
            XDATA = .TRUE.
            IPW = IPX
          ELSE
            IF( MYCOL .EQ. IXPOS ) THEN
              CALL PBSVECADD( ICONTXT, 'V', NP, ONE, X,INCX, ZERO,
     $                        WORK(IPX), 1 )
              CALL SGEBS2D( ICONTXT, 'Row', '1-tree', 1, NP,
     $                      WORK(IPX), 1 )
            ELSE
              CALL SGEBR2D( ICONTXT, 'Row', '1-tree', 1, NP,
     $                      WORK(IPX), 1, MYROW, IXPOS )
            END IF
          END IF
        END IF
*
*       Transpose a column vector X to WORK(IPT)
*
        IF( XDATA ) THEN
          CALL PBSTRNV( ICONTXT, 'Col', 'T', N, NB, NZ, X, INCX, ZERO,
     $                  WORK(IPT), 1, IAROW, -1, -1, IACOL, WORK(IPW) )
        ELSE
          CALL PBSTRNV( ICONTXT, 'Col', 'T', N, NB, NZ, WORK(IPX), 1,
     $                  ZERO, WORK(IPT), 1, IAROW, -1, -1, IACOL,
     $                  WORK(IPW) )
        END IF
*
*     If x and y are distributed rowwise (in a row of processes)
*
      ELSE
*
*       Form  y := alpha*A*x + beta*y
*                        _____________
*                       |\_           |
*                       |  \_         |
*                       |    \_       |
*     ====(x)==== = a * |      A_     | * ====(x)==== + b * ====(y)====
*                       |        \_   |
*                       |          \_ |
*                       |____________\|
*
        IF(      IXPOS.LT.-1 .OR. IXPOS.GE.NPROW ) THEN
          INFO = 17
        ELSE IF( IYPOS.LT.0  .OR. IYPOS.GE.NPROW ) THEN
          INFO = 18
        END IF
        IF( INFO .NE. 0 ) GO TO 10
*
*       Initialize parameters
*
        IF( LSAME( YWORK, 'Y' ) ) THEN
          IPZ = 1
          YDATA = .TRUE.
          IF( MYROW .EQ. IYPOS ) THEN
            CALL PBSVECADD( ICONTXT, 'G', NQ, ZERO, DUMMY, 1, BETA,
     $                      Y, INCY )
          ELSE
            CALL PBSVECADD( ICONTXT, 'G', NQ, ZERO, DUMMY, 1, ZERO,
     $                      Y, INCY )
          END IF
        ELSE
          IPY = 1
          IPZ = NQ + IPY
          CALL PBSVECADD( ICONTXT, 'G', NQ, ZERO, DUMMY, 1, ZERO,
     $                    WORK(IPY), 1 )
        END IF
*
        CALL PBSVECADD( ICONTXT, 'G', NP, ZERO, DUMMY, 1, ZERO,
     $                  WORK(IPZ), 1 )
*
        IPT = NP + IPZ
        IPX = NP + IPT
        IPW = NQ + IPX
*
*       Broadcast X if necessary
*
        IF( .NOT. XDATA ) THEN
          IF( LSAME( XWORK, 'Y' ) ) THEN
            IF( MYROW .EQ. IXPOS ) THEN
              CALL SGEBS2D( ICONTXT, 'Col', '1-tree', 1, NQ, X, INCX )
            ELSE
              CALL SGEBR2D( ICONTXT, 'Col', '1-tree', 1, NQ, X, INCX,
     $                      IXPOS, MYCOL )
            END IF
            XDATA = .TRUE.
            IPW = IPX
          ELSE
            IF( MYROW .EQ. IXPOS ) THEN
              CALL PBSVECADD( ICONTXT, 'V', NQ, ONE, X,INCX, ZERO,
     $                        WORK(IPX), 1 )
              CALL SGEBS2D( ICONTXT, 'Col', '1-tree', 1, NQ,
     $                      WORK(IPX), 1 )
            ELSE
              CALL SGEBR2D( ICONTXT, 'Col', '1-tree', 1, NQ,
     $                      WORK(IPX), 1, IXPOS, MYCOL )
            END IF
          END IF
        END IF
*
*       Transpose a row vector X (= WORK(IPX)) to WORK(IPT)
*
        IF( XDATA ) THEN
          CALL PBSTRNV( ICONTXT, 'Row', 'T', N, NB, NZ, X, INCX, ZERO,
     $                  WORK(IPT), 1, -1, IACOL, IAROW, -1, WORK(IPW) )
        ELSE
          CALL PBSTRNV( ICONTXT, 'Row', 'T', N, NB, NZ, WORK(IPX), 1,
     $                  ZERO, WORK(IPT), 1, -1, IACOL, IAROW, -1,
     $                  WORK(IPW) )
        END IF
      END IF
*
*     PART 2: Compute Y
*     =================
*
      IF( NP.EQ.0 .OR. NQ.EQ.0 ) GO TO 120
*
*     If A is a symmetric upper triangular matrix,
*
      IF( UPPER ) THEN
        ISZCMP = ICEIL( MULLEN, LQBZ )
        IF( ISZCMP .LE. 0 ) ISZCMP = 1
        IPBZ = ISZCMP * LPBZ
        IQBZ = ISZCMP * LQBZ
        JPBZ = 0
        JQBZ = 0
*
        DO 60 JJ = 1, ICEIL(NQ+JZ, IQBZ)
          LMW = MIN( IPBZ-IZ, NP-JPBZ )
          LNW = MIN( IQBZ-JZ, NQ-JQBZ )
          LDW = MAX( 1, LMW )
          JNPBZ = JPBZ + LMW
          JNQBZ = JQBZ + LNW
*
*         Copy the upper triangular matrix A to WORK(IPW)
*
          MZROW = MRROW
          MZCOL = MRCOL
          KI = 0
          IF( MYCOL .EQ. IACOL ) KZ = JZ
*
          DO 30 KJ = 0, LCMQ-1
   20        CONTINUE
             IF( MZROW .LT. MZCOL ) THEN
                MZROW = MZROW + NPROW
                KI = KI + 1
                GO TO 20
             END IF
             KIZ = MAX( 0, KI*NB-IZ )
             KJZ = MAX( 0, KJ*NB-JZ )
             FORM = 'G'
             IF( MZROW .EQ. MZCOL )
     $          FORM = 'T'
             MZCOL = MZCOL + NPCOL
*
             CALL PBSLACP1( ICONTXT, 'Upper', FORM, 'No', KIZ, NB, KZ,
     $                      A( JPBZ+1, JQBZ+KJZ+1 ), LDA,
     $                      WORK( KJZ*LMW+IPW ), LMW, LPBZ, LQBZ, LMW,
     $                      LNW-KJZ )
             KZ = 0
   30     CONTINUE
*
*         Compute Y
*
          IF( COLUMN ) THEN
            IF( YDATA ) THEN
              CALL SGEMV( 'No', LMW,  LNW, ALPHA, WORK(IPW), LDW,
     $                    WORK(JQBZ+IPT), 1, ONE, Y(JPBZ*INCY+1), INCY )
              CALL SGEMV( 'No', JPBZ, LNW, ALPHA, A(1,JQBZ+1), LDA,
     $                    WORK(JQBZ+IPT), 1, ONE, Y, INCY )
            ELSE
              CALL SGEMV( 'No', LMW,  LNW, ALPHA, WORK(IPW), LDW,
     $                    WORK(JQBZ+IPT), 1, ZERO, WORK(JPBZ+IPY), 1 )
              CALL SGEMV( 'No', JPBZ, LNW, ALPHA, A(1,JQBZ+1), LDA,
     $                    WORK(JQBZ+IPT), 1, ONE, WORK(IPY), 1 )
            END IF
          ELSE
            IF( XDATA ) THEN
              CALL SGEMV( 'No', LMW,  LNW, ALPHA, WORK(IPW), LDW,
     $                    X(JQBZ*INCX+1),INCX, ZERO, WORK(JPBZ+IPZ),1 )
              CALL SGEMV( 'No', JPBZ, LNW, ALPHA, A(1,JQBZ+1), LDA,
     $                    X(JQBZ*INCX+1), INCX, ONE, WORK(IPZ), 1 )
            ELSE
              CALL SGEMV( 'No', LMW,  LNW, ALPHA, WORK(IPW), LDW,
     $                    WORK(JQBZ+IPX), 1, ZERO, WORK(JPBZ+IPZ), 1 )
              CALL SGEMV( 'No', JPBZ, LNW, ALPHA, A(1,JQBZ+1), LDA,
     $                    WORK(JQBZ+IPX), 1, ONE, WORK(IPZ), 1 )
            END IF
          END IF
*
*         Delete the diagonal elements of upper tri. matrix WORK(IPW)
*
          MZROW = MRROW
          MZCOL = MRCOL
          KI = 0
          IF( MYROW.EQ.IAROW .AND. MYCOL.EQ.IACOL ) KZ = IZ
*
          DO 50 KJ = 0, LCMQ-1
   40       CONTINUE
            IF( MZROW .LT. MZCOL ) THEN
              MZROW = MZROW + NPROW
              KI = KI + 1
              GO TO 40
            END IF
            KIZ = MAX( 0, KI*NB-IZ )
            KJZ = MAX( 0, KJ*NB-JZ )
            IF( MZROW .EQ. MZCOL )
     $        CALL PBSDZRO1( KIZ, NB, KZ, WORK(KJZ*LMW+IPW), LMW,
     $                       LPBZ, LQBZ, LNW-KJZ )
            KZ    = 0
            MZCOL = MZCOL + NPCOL
   50     CONTINUE
*
*         Compute Y
*
          IF( COLUMN ) THEN
            IF( XDATA ) THEN
              CALL SGEMV( 'Trans', LMW,  LNW, ALPHA, WORK(IPW), LDW,
     $                    X(JPBZ*INCX+1),INCX, ZERO, WORK(JQBZ+IPZ),1 )
              CALL SGEMV( 'Trans', JPBZ, LNW, ALPHA, A(1,JQBZ+1), LDA,
     $                    X, INCX, ONE, WORK(JQBZ+IPZ), 1 )
            ELSE
              CALL SGEMV( 'Trans', LMW,  LNW, ALPHA, WORK(IPW), LDW,
     $                    WORK(JPBZ+IPX), 1, ZERO, WORK(JQBZ+IPZ), 1 )
              CALL SGEMV( 'Trans', JPBZ, LNW, ALPHA, A(1,JQBZ+1), LDA,
     $                    WORK(IPX), 1, ONE, WORK(JQBZ+IPZ), 1 )
            END IF
          ELSE
            IF( YDATA ) THEN
              CALL SGEMV( 'Trans', LMW,  LNW, ALPHA, WORK(IPW), LDW,
     $                    WORK(JPBZ+IPT), 1, ONE, Y(JQBZ*INCY+1), INCY )
              CALL SGEMV( 'Trans', JPBZ, LNW, ALPHA, A(1,JQBZ+1), LDA,
     $                    WORK(IPT), 1, ONE, Y(JQBZ*INCY+1), INCY )
            ELSE
              CALL SGEMV( 'Trans', LMW,  LNW, ALPHA, WORK(IPW), LDW,
     $                    WORK(JPBZ+IPT), 1, ZERO, WORK(JQBZ+IPY), 1 )
              CALL SGEMV( 'Trans', JPBZ, LNW, ALPHA, A(1,JQBZ+1), LDA,
     $                    WORK(IPT), 1, ONE, WORK(JQBZ+IPY), 1 )
            END IF
          END IF
*
          JPBZ = JNPBZ
          JQBZ = JNQBZ
          IZ   = 0
          JZ   = 0
*
   60   CONTINUE
*
*     If A is a symmetric lower triangular matrix,
*
      ELSE
*
        ISZCMP = ICEIL( MULLEN, LQBZ )
        IF( ISZCMP .LE. 0 ) ISZCMP = 1
        IPBZ = ISZCMP * LPBZ
        IQBZ = ISZCMP * LQBZ
        JPBZ = 0
        JQBZ = 0
*
        DO 110 JJ = 1, ICEIL(NQ+JZ, IQBZ)
          LMW = MIN( IPBZ-IZ, NP-JPBZ )
          LNW = MIN( IQBZ-JZ, NQ-JQBZ )
          LDW = MAX( 1, LMW )
          JNPBZ = JPBZ + LMW
          JNQBZ = JQBZ + LNW
*
*         Copy the lower triangular matrix A to WORK(IPW)
*
          MZROW = MRROW
          MZCOL = MRCOL
          KI = 0
          IF( MYCOL .EQ. IACOL ) KZ = JZ
*
          DO 80 KJ = 0, LCMQ-1
   70        CONTINUE
             IF( MZROW .LT. MZCOL ) THEN
                MZROW = MZROW + NPROW
                KI = KI + 1
                GO TO 70
             END IF
             KIZ = MAX( 0, KI*NB-IZ )
             KJZ = MAX( 0, KJ*NB-JZ )
             FORM = 'G'
             IF( MZROW .EQ. MZCOL )
     $          FORM = 'T'
             MZCOL = MZCOL + NPCOL
*
             CALL PBSLACP1( ICONTXT, 'Lower', FORM, 'No', KIZ, NB, KZ,
     $                      A( JPBZ+1, JQBZ+KJZ+1 ), LDA,
     $                      WORK( KJZ*LMW+IPW ), LMW, LPBZ, LQBZ, LMW,
     $                      LNW-KJZ )
             KZ = 0
   80     CONTINUE
*
*         Compute Y
*
          IF( COLUMN ) THEN
            IF( YDATA ) THEN
              CALL SGEMV( 'No', LMW, LNW, ALPHA, WORK(IPW), LDW,
     $                    WORK(JQBZ+IPT), 1, ONE, Y(JPBZ*INCY+1), INCY )
              CALL SGEMV( 'No', NP-JNPBZ, LNW, ALPHA,
     $                    A(JNPBZ+1,JQBZ+1), LDA, WORK(JQBZ+IPT), 1,
     $                    ONE, Y(JNPBZ*INCY+1), INCY )
            ELSE
              CALL SGEMV( 'No', LMW, LNW, ALPHA, WORK(IPW), LDW,
     $                    WORK(JQBZ+IPT), 1, ONE, WORK(JPBZ+IPY), 1 )
              CALL SGEMV( 'No', NP-JNPBZ, LNW, ALPHA,
     $                    A(JNPBZ+1,JQBZ+1), LDA, WORK(JQBZ+IPT), 1,
     $                    ONE, WORK(JNPBZ+IPY), 1 )
            END IF
          ELSE
            IF( XDATA ) THEN
              CALL SGEMV( 'No', LMW, LNW, ALPHA, WORK(IPW), LDW,
     $                    X(JQBZ*INCX+1), INCX, ONE, WORK(JPBZ+IPZ), 1 )
              CALL SGEMV( 'No', NP-JNPBZ, LNW, ALPHA,
     $                    A(JNPBZ+1,JQBZ+1), LDA, X(JQBZ*INCX+1), INCX,
     $                    ONE, WORK(JNPBZ+IPZ), 1 )
            ELSE
              CALL SGEMV( 'No', LMW, LNW, ALPHA, WORK(IPW), LDW,
     $                    WORK(JQBZ+IPX), 1, ONE, WORK(JPBZ+IPZ), 1 )
              CALL SGEMV( 'No', NP-JNPBZ, LNW, ALPHA,
     $                    A(JNPBZ+1,JQBZ+1), LDA, WORK(JQBZ+IPX), 1,
     $                    ONE, WORK(JNPBZ+IPZ), 1 )
            END IF
          END IF
*
*         Delete the diagonal elements of lower tri. matrix WORK(IPW)
*
          MZROW = MRROW
          MZCOL = MRCOL
          KI = 0
          IF( MYROW.EQ.IAROW .AND. MYCOL.EQ.IACOL ) KZ = JZ
*
          DO 100 KJ = 0, LCMQ-1
   90       CONTINUE
            IF( MZROW .LT. MZCOL ) THEN
              MZROW = MZROW + NPROW
              KI = KI + 1
              GO TO 90
            END IF
            KIZ = MAX( 0, KI*NB-IZ )
            KJZ = MAX( 0, KJ*NB-JZ )
            IF( MZROW .EQ. MZCOL )
     $        CALL PBSDZRO1( KIZ, NB, KZ, WORK(KJZ*LMW+IPW), LMW,
     $                       LPBZ, LQBZ, LNW-KJZ )
            KZ    = 0
            MZCOL = MZCOL + NPCOL
  100     CONTINUE
*
*         Compute Y
*
          IF( COLUMN ) THEN
            IF( XDATA ) THEN
              CALL SGEMV( 'Trans', LMW, LNW, ALPHA, WORK(IPW), LDW,
     $                    X(JPBZ*INCX+1),INCX, ZERO, WORK(JQBZ+IPZ), 1 )
              CALL SGEMV( 'Trans', NP-JNPBZ, LNW, ALPHA,
     $                    A(JNPBZ+1,JQBZ+1), LDA, X(JNPBZ*INCX+1), INCX,
     $                    ONE, WORK(JQBZ+IPZ), 1 )
            ELSE
              CALL SGEMV( 'Trans', LMW, LNW, ALPHA, WORK(IPW), LDW,
     $                    WORK(JPBZ+IPX), 1, ZERO, WORK(JQBZ+IPZ), 1 )
              CALL SGEMV( 'Trans', NP-JNPBZ, LNW, ALPHA,
     $                    A(JNPBZ+1,JQBZ+1), LDA, WORK(JNPBZ+IPX), 1,
     $                    ONE, WORK(JQBZ+IPZ), 1 )
            END IF
          ELSE
            IF( YDATA ) THEN
              CALL SGEMV( 'Trans', LMW, LNW, ALPHA, WORK(IPW), LDW,
     $                    WORK(JPBZ+IPT), 1, ONE, Y(JQBZ*INCY+1), INCY )
              CALL SGEMV( 'Trans', NP-JNPBZ, LNW, ALPHA,
     $                    A(JNPBZ+1,JQBZ+1), LDA, WORK(JNPBZ+IPT), 1,
     $                    ONE, Y(JQBZ*INCY+1), INCY )
            ELSE
              CALL SGEMV( 'Trans', LMW, LNW, ALPHA, WORK(IPW), LDW,
     $                    WORK(JPBZ+IPT), 1, ZERO, WORK(JQBZ+IPY), 1 )
              CALL SGEMV( 'Trans', NP-JNPBZ, LNW, ALPHA,
     $                    A(JNPBZ+1,JQBZ+1), LDA, WORK(JNPBZ+IPT), 1,
     $                    ONE, WORK(JQBZ+IPY), 1 )
            END IF
          END IF
*
          JPBZ = JNPBZ
          JQBZ = JNQBZ
          IZ   = 0
          JZ   = 0
  110   CONTINUE
      END IF
*
  120 CONTINUE
*
*     PART 3: Collect and add Y, Y := Y ( = WORK(IPY) ) + WORK(IPZ)'
*     ==============================================================
*
*     If X and Y are distributed columnwise ( XYDIST = 'C' )
*
      IF( COLUMN ) THEN
        IF( YDATA ) THEN
          CALL SGSUM2D( ICONTXT, 'Row', '1-tree', 1, NP, Y, INCY,
     $                  MYROW, IYPOS )
        ELSE
          IF( MYCOL .EQ. IYPOS ) THEN
            CALL PBSVECADD( ICONTXT, 'V', NP, ONE, WORK(IPY), 1, BETA,
     $                      Y, INCY )
            CALL SGSUM2D( ICONTXT, 'Row', '1-tree', 1, NP, Y, INCY,
     $                    MYROW, IYPOS )
          ELSE
            CALL SGSUM2D( ICONTXT, 'Row', '1-tree', 1, NP, WORK(IPY), 1,
     $                    MYROW, IYPOS )
          END IF
        END IF
*
        CALL SGSUM2D( ICONTXT, 'Col', '1-tree', 1, NQ, WORK(IPZ), 1,
     $                IAROW, MYCOL )
        CALL PBSTRNV( ICONTXT, 'Row', 'T', N, NB, NZ, WORK(IPZ), 1, ONE,
     $                Y, INCY, IAROW, IACOL, IAROW, IYPOS, WORK(IPT) )
*
*     If X and Y are distributed rowwise ( XYDIST = 'R' )
*
      ELSE
        IF( YDATA ) THEN
          CALL SGSUM2D( ICONTXT, 'Col', '1-tree', 1, NQ, Y, INCY,
     $                  IYPOS, MYCOL )
        ELSE
          IF( MYROW .EQ. IYPOS ) THEN
            CALL PBSVECADD( ICONTXT, 'V', NQ, ONE, WORK(IPY), 1, BETA,
     $                      Y, INCY )
            CALL SGSUM2D( ICONTXT, 'Col', '1-tree', 1, NQ, Y, INCY,
     $                    IYPOS, MYCOL )
          ELSE
            CALL SGSUM2D( ICONTXT, 'Col', '1-tree', 1, NQ, WORK(IPY), 1,
     $                    IYPOS, MYCOL )
          END IF
        END IF
*
        CALL SGSUM2D( ICONTXT, 'Row', '1-tree', 1, NP, WORK(IPZ), 1,
     $                MYROW, IACOL )
        CALL PBSTRNV( ICONTXT, 'Col', 'T', N, NB, NZ, WORK(IPZ), 1, ONE,
     $                Y, INCY, IAROW, IACOL, IYPOS, IACOL, WORK(IPT) )
      END IF
*
      RETURN
*
*     End of PBSSYMV
*
      END
