package jumpshot;

import java.awt.*;
import java.awt.event.*;
import java.util.Vector;
import java.awt.event.*;

//Dialog displaying Zoom options
public class ZoomDlg extends Dialog 
implements ActionListener {
  ClogDisplay parent;
  MyTextField zFacTxField, fromTxField, toTxField;
  
  //Constructor
  public ZoomDlg (ClogDisplay p) {
    super ((Frame)p, "Zoom Options", false);
    parent = p;
    setup ();
  }
  //setup methods------------------------------------------------------------
  void setup () {
    setupPanel ();
    adjustDlgStuff ();
    
    // Define, instantiate and register a WindowListener object.
    addWindowListener (new WindowAdapter () {
      public void windowClosing (WindowEvent e) {setVisible  (false);}
    });
  }
  
  void adjustDlgStuff () {
    setFont (parent.frameFont);
    setBackground (parent.frameBColor);
    setForeground (parent.frameFColor);
  }

  void setupPanel () {
    setLayout (new GridBagLayout ());
    GridBagConstraints con = new GridBagConstraints ();
    con.fill = GridBagConstraints.BOTH;
    con.weightx = 1.0; con.weighty = 1.0;
    
    con.gridx = 0;
    add (new Label ("Zoom Factor:"), con);
    
    con.gridx = 1;
    add (new MyButton ("Change Zoom Factor", this), con);
    
    con.gridx = 1; con.gridy = 1;
    add (zFacTxField = new MyTextField ("", 20, true), con);
    
    con.gridx = 0; con.gridy = 2;
    add (new Label ("Explicit time:") , con);
        
    con.gridx = 1;
    add (new MyButton ("Change Explicit Time", this), con);

    con.gridx = 0; con.gridy = 3;
    add (new Label ("From:"), con);
    
    con.gridx = 1;
    add (fromTxField = new MyTextField ("", 20, true), con);
    
    con.gridx = 0; con.gridy = 4;
    add (new Label ("To:"), con);
    
    con.gridx = 1;
    add (toTxField = new MyTextField ("", 20, true), con);
    
    con.gridx = 0; con.gridy = 5;
    add (new MyButton ("Close", this), con);

    pack ();
    setSize (getMinimumSize ());
  }
  //end of setup methods---------------------------------------------------------------
  //Event handling methods--------------------------------------------------------------
  //events only generated by buttons are caught in this dialog
  //this method handles events generated by buttons
  public void actionPerformed (ActionEvent evt) {
    String command = evt.getActionCommand ();
    if (command.equals ("Close")) setVisible (false);
    else if (command.equals ("Change Zoom Factor")) {
      double val = (new Double (zFacTxField.getText ())).doubleValue ();
      if (val <= 0) new ErrorDiag (parent, "Invalid Zoom Factor Entered. Try Again.");
      else parent.canvas.changeZF (val);
    }
    else if (command.equals ("Change Explicit Time"))
      parent.canvas.changeExTime ((new Double (fromTxField.getText ())).doubleValue (),
                                  (new Double (toTxField.getText ())).doubleValue ());
  }
  //end of event handling----------------------------------------------------------------
  public void fromTime (double t) {fromTxField.setText (Double.toString (t));}
  public void toTime (double t) {toTxField.setText (Double.toString (t));}
  public void zoomF (double t) {zFacTxField.setText (Double.toString (t));}
}








