package jumpshot;

import java.awt.*;
import java.awt.event.*;
import java.util.Vector;

//this is the dialog used to manipulate process time lines. It is displayed
//when the user clicks upon a process number drawn on VertScale
public class ProcDlg extends Dialog 
implements AdjustmentListener, ActionListener, ItemListener {
  ClogDisplay parent;

  Font dlgFont;
  Choice procChoice;
  Choice dprocChoice;
  Checkbox displayChkBox;
  MyButton directionButton;
  MyTextField procField;
  Scrollbar hbar;

  JProcess currProc;
  JProcess selectedProc;
  Vector procVector, dprocVector;

  int tval; 
  int maxBackValue;
  boolean direction;

  //Constructor
  public ProcDlg (ClogDisplay p) {
    super ((Frame)p, "Adjust Process", false);
    parent = p;
    setup ();
  }
  //setup methods---------------------------------------------------------------
  void setup () {
    adjustDlgStuff ();
    setupData ();
    setuphbar ();
    setupPanel ();
    
    // Define, instantiate and register a WindowListener object.
    addWindowListener (new WindowAdapter () {
      public void windowClosing (WindowEvent e) {setVisible (false);}
    });
  }
  
  void adjustDlgStuff () {
    setFont (dlgFont = parent.frameFont);
    setBackground (parent.frameBColor);
    setForeground (parent.frameFColor);
  }

  void setupData () {
    procChoice = new Choice (); procChoice.setFont (dlgFont);
    dprocChoice = new Choice (); procChoice.setFont (dlgFont);
    procChoice.addItemListener (this); dprocChoice.addItemListener (this);
    procVector = parent.canvas.procVector;
    dprocVector = parent.canvas.dprocVector;
    for (int i = 0; i < procVector.size (); i++) 
      procChoice.addItem (Integer.toString (((JProcess)procVector.elementAt (i)).procId));
    for (int i = 0; i < dprocVector.size (); i++) 
      dprocChoice.addItem (Integer.toString (((JProcess)dprocVector.elementAt (i)).procId));
  }
  
  void setuphbar () {
    hbar = new Scrollbar (Scrollbar.HORIZONTAL, 0, 0, 0, parent.canvas.widthCan - 
                          parent.paneC.getVScrollbarWidth ());
    hbar.addAdjustmentListener (this);
    directionButton = new MyButton ("Forward", this); direction = true;
  }
  
  void setupPanel () {
    setLayout (new GridBagLayout ());
    GridBagConstraints con = new GridBagConstraints ();
    con.fill = GridBagConstraints.BOTH;
    con.weightx = 1.0; con.weighty = 1.0;
    
    con.gridx = 0; con.gridy = 0; 
    add (new Label ("Current Process"), con);
    
    con.gridx = 1; 
    add (procField = new MyTextField (3, false), con);
    
    con.gridx = 2;
    add (directionButton, con);
    
    con.gridx = 3; con.gridwidth = 2;
    add (hbar, con);
    
    con.gridx = 5;
    add (new MyButton ("Reset", this), con);
    
    con.gridx = 0; con.gridy = 1; con.gridwidth = 1;
    add (new Label ("Available"), con);

    con.gridx = 1; con.gridy = 1;
    add (procChoice, con);
    
    con.gridx = 2;
    add (displayChkBox = new Checkbox ("Display"), con);
    displayChkBox.addItemListener (this);
    
    con.gridx = 3;
    add (new MyButton ("Swap", this), con);

    con.gridx = 4;
    add (new MyButton ("Delete", this), con);
        
    con.gridx = 0; con.gridy = 2;
    add (new Label ("Deleted"), con);
    
    con.gridx = 1; con.gridwidth = 2;
    add (dprocChoice, con);
    
    con.gridx = 3; con.gridwidth = 1;
    add (new MyButton ("Insert", this), con);
    
    con.gridx = 0; con.gridy = 3;
    add (new MyButton ("Close", this), con);
        
    //con.gridx = 1;
    // add (new MyButton ("Apply", this), con);
    
    pack ();
    setSize (getMinimumSize ());
  }
  //end of setup methods-----------------------------------------------------------------

  //event handler methods---------------------------------------------------------------
  //events generated from buttons, choice lists, checkboxes and scrollbar are caught
  
  //Handles action events generated by buttons
  public void actionPerformed (ActionEvent evt) {
    String command = evt.getActionCommand ();
    if (command.equals ("Insert")) {
      if (dprocVector.size () > 0) {
        String selected = dprocChoice.getSelectedItem ();
        int selectedId = (Integer.valueOf (selected)).intValue ();
        parent.canvas.InsertProc (parent.canvas.getIndex (dprocVector, selectedId),
                                  currProc.procId);
        adjustChoices ();
        parent.canvas.Refresh ();
        setVisible (false);
      }
    }
    else if (command.equals ("Swap")) {
      if (procVector.size () > 1) {
        int selectedId = (Integer.valueOf (procChoice.getSelectedItem ())).intValue ();
        
        if (currProc.procId != selectedProc.procId) {
          int selectedIndex = parent.canvas.getIndex (procVector, selectedProc.procId);
          int currIndex = parent.canvas.getIndex (procVector, currProc.procId);
          procVector.setElementAt (currProc, selectedIndex);
          procVector.setElementAt (selectedProc, currIndex);
        }
        parent.canvas.Refresh ();
        setVisible (false);
      }
    }
    else if (command.equals ("Delete")) {
      if (procVector.size () > 1) {
        String selected = procChoice.getSelectedItem ();
        int selectedId = (Integer.valueOf (selected)).intValue ();
        parent.canvas.DeleteProc (parent.canvas.getIndex (procVector, selectedId));
        adjustChoices ();
        parent.canvas.Refresh ();
        setVisible (false);
      }
    }
    else if (command.equals ("Close")) setVisible (false);
    else if (command.equals ("Forward")) {
      directionButton.setLabel ("Backward");
      maxBackValue = parent.canvas.getMaxDiff (currProc);
      if (maxBackValue > parent.canvas.widthCan) 
        maxBackValue = parent.canvas.widthCan;
      //Range of values [0 .. max]
      tval = 0;
      hbar.setMaximum (maxBackValue);
      hbar.setMinimum (0);
      hbar.setValue (maxBackValue);
      direction = false;
    }
    else if (command.equals ("Backward")) {
      directionButton.setLabel ("Forward");
      hbar.setValue (0); tval = 0;
      hbar.setMinimum (0);
      hbar.setMaximum (parent.canvas.widthCan);
      direction = true;
    }
    else if (command.equals ("Reset")) {
      parent.canvas.resetTimeLine (currProc);
      hbar.setValue (0); tval = 0;
      hbar.setMaximum (parent.canvas.widthCan);
      directionButton.setLabel ("Forward"); direction = true;
    }
  }
  
  //Handles AdjustmentEvents generated by the scrollbar
  public void adjustmentValueChanged (AdjustmentEvent e) {
    int val = hbar.getValue ();
    if (!direction) val = maxBackValue - val;
    parent.canvas.pushTimeLine (currProc, val - tval, direction);
    tval = val;
  }
  
  //Handles ItemEvents generated by the checkbox and the choice lists
  public void itemStateChanged (ItemEvent e) {
    Object o = e.getItem ();
    if (o.toString ().equals ("Display")) {
      selectedProc.dispStatus = displayChkBox.getState ();
      parent.canvas.Refresh ();
      setVisible (false);
    }
    else {
      displayChkBox.setState (getSelectedProc ().dispStatus);
    }
  }
  //end of event handler methods------------------------------------------------
  
  //This method is used to reset values of this object for the given process
  //It must be noted that this object is reused for all processes
  void reset (JProcess p) {
    currProc = p;
    procField.setText (Integer.toString (p.procId));
    displayChkBox.setState (getSelectedProc ().dispStatus);
    directionButton.setLabel ("Forward"); direction = true;
    hbar.setValue (0); tval = 0;
    hbar.setMaximum (parent.canvas.widthCan - parent.paneC.getVScrollbarWidth ());
  }
  
  //This method returns a pointer to the JProcess selected in procChoice
  JProcess getSelectedProc () {
    String selected = procChoice.getSelectedItem ();
    int selectedId = (Integer.valueOf (selected)).intValue ();
    int selectedIndex = parent.canvas.getIndex (procVector, selectedId);
    selectedProc = (JProcess)(procVector.elementAt (selectedIndex));
    return selectedProc;
  }

  void adjustChoices () {
    procChoice.removeAll ();
    dprocChoice.removeAll ();
    for (int i = 0; i < procVector.size (); i++) 
      procChoice.addItem 
        (Integer.toString (((JProcess)procVector.elementAt (i)).procId));
    for (int i = 0; i < dprocVector.size (); i++) 
      dprocChoice.addItem 
        (Integer.toString (((JProcess)dprocVector.elementAt (i)).procId));
    sort (procChoice); sort (dprocChoice);
  }
  
  //this method sorts the contents of the given choice
  void sort (Choice ch) {
    int total = ch.getItemCount ();
    int x [] = new int [total];
    for (int i = 0; i < total; i ++)
      x [i] =   (Integer.valueOf (ch.getItem (i))).intValue ();
    
    for (int pass = 1; pass < total; pass++)
      for (int i = 0; i < total - 1; i++) {
        int curr = x [i];
        int next = x [i + 1];
        if (curr > next) {
          int temp = x [i];
          x [i] = x [i + 1];
          x [i + 1] = temp;
        }
      }
    ch.removeAll ();
    
    for (int i = 0; i < total; i++) 
      ch.addItem (Integer.toString (x [i]));
  }
}








