package jumpshot;

import java.awt.*;
import java.io.*;
import java.awt.event.*;

//Dialog showing information about the state
class StateDlg extends Dialog {
  String title = "State Info.";
  Label a, b;
  
  //Constructor
  public StateDlg (Frame p) {
    super (p);
    setTitle (title);
    setLayout (new GridLayout (2, 1));
    add (a = new Label ()); add (b = new Label ());
    
    // Define, instantiate and register a WindowListener object.
    addWindowListener (new WindowAdapter () {
      public void windowClosing (WindowEvent e) {setVisible (false);}
    });
  }
  
  //This method extracts the relevent info from the specified state
  //and puts it in the displayed dialog
  //ps = the state whose information is to be displayed
  public void reset (ProcessState ps) {
    StateInfo info = ps.info;
    a.setText ("State: " + info.stateDef.description.desc + " from " + 
               (new Float (info.begT)).toString () + " to " + 
               (new Float (info.endT)).toString () + " ");
    b.setText ("Length: " + (new Float (info.lenT)).toString () + " (sec), Process: " + 
               Integer.toString (ps.info.procId));
    pack ();
    setSize (getMinimumSize ());
  }
}
//---------------------------------------------------------------------------------------
//Dialog showing information about a message arrow
class MsgDlg extends Dialog {
  String title = "Message Info.";
  Label a, b;

  //Constructor
  public MsgDlg (Frame p) {
    super (p);
    setTitle (title);
    setLayout (new GridLayout (3, 1));
    add (a = new Label ()); add (b = new Label ());
    
    // Define, instantiate and register a WindowListener object.
    addWindowListener (new WindowAdapter () {
      public void windowClosing (WindowEvent e) {setVisible (false);}
    });
  }
  
  //This method extracts the relevent info from the specified ArrowInfo object
  //and puts it in the displayed dialog
  //info = the ArrowInfo whose information is to be displayed
  public void reset (ArrowInfo info) {
    a.setText ("Message: Size " + Integer.toString (info.size) + ", Tag " + 
               Integer.toString (info.tag));
    b.setText ("from Process " + Integer.toString (info.begProcId) + " at " +
               (new Float (info.begT)).toString () + " (sec), to Process " +
               Integer.toString (info.endProcId) + " at " + 
               (new Float (info.endT)).toString () + " (sec)");
    pack ();
    setSize (getMinimumSize ());
  }
}
//------------------------------------------------------------------------------------
//This class implements a help dialog. The lines of text to be displayed
//in this dialog are passed on as a single string, lines seperated by
//'/n's
class HelpDlg extends Dialog 
implements ActionListener {
  String text;
  TextArea area;
  
  //Constructor
  public HelpDlg (Frame p, String s) {
    super (p, "Help", false);
    text = s;
    setup ();
  }
  //setup methods---------------------------------------------------------------
  void setup () {
    setupData ();
    setupPanel ();
    
    // Define, instantiate and register a WindowListener object.
    addWindowListener (new WindowAdapter () {
      public void windowClosing (WindowEvent e) {setVisible (false);}
    });
  }

  void setupData () {
    area = new TextArea (text, 8, 40);
    area.setEditable (false);
    area.setBackground (Color.white);
    area.setForeground (Color.black);
    area.setCursor (new Cursor (Frame.DEFAULT_CURSOR));
  }
  
  void setupPanel () {
    add (area, "Center");
    add (new MyButton ("Close", this), "South");
    pack ();
  }
  //end of setup methods-----------------------------------------------------------------

  //event handler methods---------------------------------------------------------------
  //events generated from buttons, choice lists, checkboxes and scrollbar are caught
  
  //Handles action events generated by buttons
  public void actionPerformed (ActionEvent evt) {
    String command = evt.getActionCommand ();
    if (command.equals ("Close")) setVisible (false);
  }
}  
//--------------------------------------------------------------
class ErrorDiag extends Dialog implements ActionListener
{
  public ErrorDiag(Frame  parent,String txt)
  {
    super(parent, "Error", true);
    GridBagLayout gridbag = new GridBagLayout();
    setLayout(gridbag);
    GridBagConstraints C= new GridBagConstraints();
    C.gridx=GridBagConstraints.RELATIVE;
    C.gridwidth=GridBagConstraints.REMAINDER;
    Label L=new Label(txt);
    gridbag.setConstraints(L,C);
    add(L);
    Button B=new Button("Ok");
    gridbag.setConstraints(B,C);
    B.addActionListener(this);
    add(B);
    pack();
    setVisible(true);
  }
  
  public void actionPerformed(ActionEvent evt)
  {
    if (evt.getActionCommand().equals("Ok")) 
      dispose();
  }
    
}
