!
!    "$Id: ex2f.F,v 1.8 1998/04/15 18:00:19 balay Exp $"
!
!  Description: Builds a parallel vector with 1 component on the first
!               processor, 2 on the second, etc.  Then each processor adds
!               one to all elements except the last rank.
!
!/*T
!   Concepts: Vectors^Assembling vectors;
!   Routines: VecCreateMPI(); VecGetSize(); VecSet(); VecSetValues();
!   Routines: VecView(); VecDestroy();
!   Processors: n
!T*/
! -----------------------------------------------------------------------

      program ex2f
      implicit none

! - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
!                    Include files
! - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
!
!  The following include statements are required for Fortran programs
!  that use PETSc vectors:
!     petsc.h  - base PETSc routines
!     vec.h    - vectors
!  Additional include statements may be needed if using additional
!  PETSc routines in a Fortran program, e.g.,
!     viewer.h - viewers
!     is.h     - index sets
!
#include "include/finclude/petsc.h"
#include "include/finclude/vec.h"

! - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
!                 Beginning of program
! - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 

      Vec     x
      integer N, ierr, rank, i
      Scalar  one

      call PetscInitialize(PETSC_NULL_CHARACTER,ierr)
      one   = 1.0
      call MPI_Comm_rank(PETSC_COMM_WORLD,rank,ierr)

!  Create a parallel vector.
!   - In this case, we specify the size of the local portion on 
!     each processor, and PETSc computes the global size.  Alternatively,
!     if we pass the global size and use PETSC_DECIDE for the 
!     local size PETSc will choose a reasonable partition trying 
!     to put nearly an equal number of elements on each processor.


      call VecCreateMPI(PETSC_COMM_WORLD,rank+1,PETSC_DECIDE,x,ierr)
      call VecGetSize(x,N,ierr)
      call VecSet(one,x,ierr)

!  Set the vector elements.
!   - Note that VecSetValues() uses 0-based row and column numbers
!     in Fortran as well as in C.
!   - Always specify global locations of vector entries.
!   - Each processor can contribute any vector entries,
!     regardless of which processor "owns" them; any nonlocal
!     contributions will be transferred to the appropriate processor
!     during the assembly process.
!   - In this example, the flag ADD_VALUES indicates that all
!     contributions will be added together.

      do 100 i=0, N-rank-1
         call VecSetValues(x,1,i,one,ADD_VALUES,ierr)
 100  continue

!  Assemble vector, using the 2-step process:
!    VecAssemblyBegin(), VecAssemblyEnd()
!  Computations can be done while messages are in transition
!  by placing code between these two statements.

      call VecAssemblyBegin(x,ierr)
      call VecAssemblyEnd(x,ierr)

!  View the vector; then destroy it.

      call VecView(x,VIEWER_STDOUT_WORLD,ierr)
      call VecDestroy(x,ierr)

      call PetscFinalize(ierr)
      end
 
