      subroutine dgl2hs(nx,ny,x,s,y,wa1,wa2,vornum)
      integer nx, ny, vornum
      double precision x(4*nx*ny), s(4*nx*ny), y(4*nx*ny)
      double precision wa1(4*(nx+1)*(ny+1)), wa2(4*(nx+1)*(ny+1))
!     **********
!
!     Subroutine dgl2hs
!
!     This subroutine computes the product f''(x)*s = y, where f''(x)
!     is the Hessian matrix for the Ginzburg-Landau (2-dimensional)
!     problem evaluted at x.
!
!     The subroutine statement is
!
!       subroutine dgl2hs(nx,ny,x,s,y,task,wa1,wa2,vornum)
!
!     where
!
!       nx is an integer variable.
!         On entry nx is the number of grid points in the first
!            coordinate direction.
!         On exit nx is unchanged.
!
!       ny is an integer variable.
!         On entry ny is the number of grid points in the second
!            coordinate direction.
!         On exit ny is unchanged.
!
!       x is a double precision array of dimension 4*nx*ny.
!         On entry x specifies the vector x.
!         On exit x is unchanged.
!
!       s is a double precision array of dimension 4*nx*ny.
!         On entry s contains the vector s.
!         On exit s is unchanged.
!
!       y is a double precision array of dimension 4*nx*ny.
!         On entry y need not be specified.
!         On exit y contains f''(x)*s.
!
!       wa1 is a double precision work array of dimension
!         4*(nx+1)(ny+1).
!
!       wa2 is a double precision work array of dimension
!         4*(nx+1)(ny+1).
!
!       vornum is an integer variable.
!         On entry vornum specifies the number of vortices.
!         On exit vornum is unchanged.
!
!     Subprograms called
!
!       MINPACK-2  ...  dgl2co
!
!     MINPACK-2 Project. November 1993.
!     Argonne National Laboratory.
!     Brett M. Averick
!
!     **********
      double precision zero
      parameter (zero=0.0d0)

      integer ctr, i, itemp, j, k

      external dgl2co

      itemp = (nx+1)*(ny+1)

!     Pack work array.

      ctr = 1
      do 20 j = 1, ny
         do 10 i = 1, nx
            k = (j-1)*nx + i
            wa2(ctr) = s(k)
            wa1(ctr) = x(k)
            wa2(itemp+ctr) = s(nx*ny+k)
            wa1(itemp+ctr) = x(nx*ny+k)
            wa2(2*itemp+ctr) = s(2*nx*ny+k)
            wa1(2*itemp+ctr) = x(2*nx*ny+k)
            wa2(3*itemp+ctr) = s(3*nx*ny+k)
            wa1(3*itemp+ctr) = x(3*nx*ny+k)
            ctr = ctr + 1
   10    continue
         wa1(ctr) = zero
         wa2(ctr) = zero
         wa1(itemp+ctr) = zero
         wa2(itemp+ctr) = zero
         wa1(2*itemp+ctr) = zero
         wa2(2*itemp+ctr) = zero
         wa1(3*itemp+ctr) = zero
         wa2(3*itemp+ctr) = zero
         ctr = ctr + 1
   20 continue

      call dgl2co(1,nx,ny,wa1(1),wa2(1),1,wa1(itemp+1),wa2(itemp+1),1,  &
     &            wa1(2*itemp+1),wa2(2*itemp+1),1,wa1(3*itemp+1),       &
     &            wa2(3*itemp+1),1,y(1),1,y(nx*ny+1),1,y(2*nx*ny+1),1,  &
     &            y(3*nx*ny+1),1,vornum)

!     Unpack work array

      ctr = 1
      do 40 j = 1, ny
         do 30 i = 1, nx
            k = (j-1)*nx + i
            s(k) = wa2(ctr)
            x(k) = wa1(ctr)
            s(nx*ny+k) = wa2(itemp+ctr)
            x(nx*ny+k) = wa1(itemp+ctr)
            s(2*nx*ny+k) = wa2(2*itemp+ctr)
            x(2*nx*ny+k) = wa1(2*itemp+ctr)
            s(3*nx*ny+k) = wa2(3*itemp+ctr)
            x(3*nx*ny+k) = wa1(3*itemp+ctr)
            ctr = ctr + 1
   30    continue
         ctr = ctr + 1
   40 continue

      end
