#ifdef PETSC_RCS_HEADER
static char vcid[] = "$Id: matcnv.c,v 1.9 1998/04/13 17:35:25 bsmith Exp $";
#endif

#include "petsc.h"
#include "mat.h"

extern int MatConvert_Basic(Mat,MatType,Mat *);
extern int MatConvert_SeqAIJ(Mat,MatType,Mat *);
extern int MatConvert_SeqBDiag(Mat,MatType,Mat *);

#undef __FUNC__  
#define __FUNC__ "MatConvertRegisterAll"
/*@C
    MatConvertRegisterAll - Registers all standard matrix conversion routines.

  Not Collective

  Notes: To prevent registering all matrix types; copy this routine to 
         your source code and comment out the versions below that you do not need.

.seealso: MatConvertRegister(), MatConvert()

@*/
int MatConvertRegisterAll(void)
{
  int ierr;

  PetscFunctionBegin;
  ierr = MatConvertRegister(MATSEQDENSE, MATSEQDENSE, MatConvert_Basic); CHKERRQ(ierr);
  ierr = MatConvertRegister(MATSEQDENSE, MATSEQAIJ,   MatConvert_Basic); CHKERRQ(ierr);
  ierr = MatConvertRegister(MATSEQDENSE, MATMPIAIJ,   MatConvert_Basic); CHKERRQ(ierr);
  ierr = MatConvertRegister(MATSEQDENSE, MATMPIROWBS, MatConvert_Basic); CHKERRQ(ierr);
  ierr = MatConvertRegister(MATSEQDENSE, MATSEQBDIAG, MatConvert_Basic); CHKERRQ(ierr);
  ierr = MatConvertRegister(MATSEQDENSE, MATMPIBDIAG, MatConvert_Basic); CHKERRQ(ierr);
  ierr = MatConvertRegister(MATSEQDENSE, MATMPIDENSE, MatConvert_Basic); CHKERRQ(ierr);
  ierr = MatConvertRegister(MATSEQDENSE, MATSEQBAIJ,  MatConvert_Basic); CHKERRQ(ierr);
  ierr = MatConvertRegister(MATSEQDENSE, MATMPIBAIJ,  MatConvert_Basic); CHKERRQ(ierr);

  ierr = MatConvertRegister(MATSEQAIJ, MATSEQDENSE, MatConvert_SeqAIJ); CHKERRQ(ierr);
  ierr = MatConvertRegister(MATSEQAIJ, MATSEQAIJ,   MatConvert_SeqAIJ); CHKERRQ(ierr);
  ierr = MatConvertRegister(MATSEQAIJ, MATMPIAIJ,   MatConvert_SeqAIJ); CHKERRQ(ierr);
  ierr = MatConvertRegister(MATSEQAIJ, MATMPIROWBS, MatConvert_SeqAIJ); CHKERRQ(ierr);
  ierr = MatConvertRegister(MATSEQAIJ, MATSEQBDIAG, MatConvert_SeqAIJ); CHKERRQ(ierr);
  ierr = MatConvertRegister(MATSEQAIJ, MATMPIBDIAG, MatConvert_SeqAIJ); CHKERRQ(ierr);
  ierr = MatConvertRegister(MATSEQAIJ, MATMPIDENSE, MatConvert_SeqAIJ); CHKERRQ(ierr);
  ierr = MatConvertRegister(MATSEQAIJ, MATSEQBAIJ,  MatConvert_SeqAIJ); CHKERRQ(ierr);
  ierr = MatConvertRegister(MATSEQAIJ, MATMPIBAIJ,  MatConvert_SeqAIJ); CHKERRQ(ierr);

  ierr = MatConvertRegister(MATMPIAIJ, MATSEQDENSE, MatConvert_Basic); CHKERRQ(ierr);
  ierr = MatConvertRegister(MATMPIAIJ, MATSEQAIJ,   MatConvert_Basic); CHKERRQ(ierr);
  ierr = MatConvertRegister(MATMPIAIJ, MATMPIAIJ,   MatConvert_Basic); CHKERRQ(ierr);
  ierr = MatConvertRegister(MATMPIAIJ, MATMPIROWBS, MatConvert_Basic); CHKERRQ(ierr);
  ierr = MatConvertRegister(MATMPIAIJ, MATSEQBDIAG, MatConvert_Basic); CHKERRQ(ierr);
  ierr = MatConvertRegister(MATMPIAIJ, MATMPIBDIAG, MatConvert_Basic); CHKERRQ(ierr);
  ierr = MatConvertRegister(MATMPIAIJ, MATMPIDENSE, MatConvert_Basic); CHKERRQ(ierr);
  ierr = MatConvertRegister(MATMPIAIJ, MATSEQBAIJ,  MatConvert_Basic); CHKERRQ(ierr);
  ierr = MatConvertRegister(MATMPIAIJ, MATMPIBAIJ,  MatConvert_Basic); CHKERRQ(ierr);

  ierr = MatConvertRegister(MATMPIROWBS, MATSEQDENSE, MatConvert_Basic); CHKERRQ(ierr);
  ierr = MatConvertRegister(MATMPIROWBS, MATSEQAIJ,   MatConvert_Basic); CHKERRQ(ierr);
  ierr = MatConvertRegister(MATMPIROWBS, MATMPIAIJ,   MatConvert_Basic); CHKERRQ(ierr);
  ierr = MatConvertRegister(MATMPIROWBS, MATMPIROWBS, MatConvert_Basic); CHKERRQ(ierr);
  ierr = MatConvertRegister(MATMPIROWBS, MATSEQBDIAG, MatConvert_Basic); CHKERRQ(ierr);
  ierr = MatConvertRegister(MATMPIROWBS, MATMPIBDIAG, MatConvert_Basic); CHKERRQ(ierr);
  ierr = MatConvertRegister(MATMPIROWBS, MATMPIDENSE, MatConvert_Basic); CHKERRQ(ierr);
  ierr = MatConvertRegister(MATMPIROWBS, MATSEQBAIJ,  MatConvert_Basic); CHKERRQ(ierr);
  ierr = MatConvertRegister(MATMPIROWBS, MATMPIBAIJ,  MatConvert_Basic); CHKERRQ(ierr);

  ierr = MatConvertRegister(MATSEQBDIAG, MATSEQDENSE, MatConvert_SeqBDiag); CHKERRQ(ierr);
  ierr = MatConvertRegister(MATSEQBDIAG, MATSEQAIJ,   MatConvert_SeqBDiag); CHKERRQ(ierr);
  ierr = MatConvertRegister(MATSEQBDIAG, MATMPIAIJ,   MatConvert_SeqBDiag); CHKERRQ(ierr);
  ierr = MatConvertRegister(MATSEQBDIAG, MATMPIROWBS, MatConvert_SeqBDiag); CHKERRQ(ierr);
  ierr = MatConvertRegister(MATSEQBDIAG, MATSEQBDIAG, MatConvert_SeqBDiag); CHKERRQ(ierr);
  ierr = MatConvertRegister(MATSEQBDIAG, MATMPIBDIAG, MatConvert_SeqBDiag); CHKERRQ(ierr);
  ierr = MatConvertRegister(MATSEQBDIAG, MATMPIDENSE, MatConvert_SeqBDiag); CHKERRQ(ierr);
  ierr = MatConvertRegister(MATSEQBDIAG, MATSEQBAIJ,  MatConvert_SeqBDiag); CHKERRQ(ierr);
  ierr = MatConvertRegister(MATSEQBDIAG, MATMPIBAIJ,  MatConvert_SeqBDiag); CHKERRQ(ierr);

  ierr = MatConvertRegister(MATMPIBDIAG, MATSEQDENSE, MatConvert_Basic); CHKERRQ(ierr);
  ierr = MatConvertRegister(MATMPIBDIAG, MATSEQAIJ,   MatConvert_Basic); CHKERRQ(ierr);
  ierr = MatConvertRegister(MATMPIBDIAG, MATMPIAIJ,   MatConvert_Basic); CHKERRQ(ierr);
  ierr = MatConvertRegister(MATMPIBDIAG, MATMPIROWBS, MatConvert_Basic); CHKERRQ(ierr);
  ierr = MatConvertRegister(MATMPIBDIAG, MATSEQBDIAG, MatConvert_Basic); CHKERRQ(ierr);
  ierr = MatConvertRegister(MATMPIBDIAG, MATMPIBDIAG, MatConvert_Basic); CHKERRQ(ierr);
  ierr = MatConvertRegister(MATMPIBDIAG, MATMPIDENSE, MatConvert_Basic); CHKERRQ(ierr);
  ierr = MatConvertRegister(MATMPIBDIAG, MATSEQBAIJ,  MatConvert_Basic); CHKERRQ(ierr);
  ierr = MatConvertRegister(MATMPIBDIAG, MATMPIBAIJ,  MatConvert_Basic); CHKERRQ(ierr);

  ierr = MatConvertRegister(MATMPIDENSE, MATSEQDENSE, MatConvert_Basic); CHKERRQ(ierr);
  ierr = MatConvertRegister(MATMPIDENSE, MATSEQAIJ,   MatConvert_Basic); CHKERRQ(ierr);
  ierr = MatConvertRegister(MATMPIDENSE, MATMPIAIJ,   MatConvert_Basic); CHKERRQ(ierr);
  ierr = MatConvertRegister(MATMPIDENSE, MATMPIROWBS, MatConvert_Basic); CHKERRQ(ierr);
  ierr = MatConvertRegister(MATMPIDENSE, MATSEQBDIAG, MatConvert_Basic); CHKERRQ(ierr);
  ierr = MatConvertRegister(MATMPIDENSE, MATMPIBDIAG, MatConvert_Basic); CHKERRQ(ierr);
  ierr = MatConvertRegister(MATMPIDENSE, MATMPIDENSE, MatConvert_Basic); CHKERRQ(ierr);
  ierr = MatConvertRegister(MATMPIDENSE, MATSEQBAIJ,  MatConvert_Basic); CHKERRQ(ierr);
  ierr = MatConvertRegister(MATMPIDENSE, MATMPIBAIJ,  MatConvert_Basic); CHKERRQ(ierr);

  ierr = MatConvertRegister(MATSEQBAIJ, MATSEQDENSE, MatConvert_Basic); CHKERRQ(ierr);
  ierr = MatConvertRegister(MATSEQBAIJ, MATSEQAIJ,   MatConvert_Basic); CHKERRQ(ierr);
  ierr = MatConvertRegister(MATSEQBAIJ, MATMPIAIJ,   MatConvert_Basic); CHKERRQ(ierr);
  ierr = MatConvertRegister(MATSEQBAIJ, MATMPIROWBS, MatConvert_Basic); CHKERRQ(ierr);
  ierr = MatConvertRegister(MATSEQBAIJ, MATSEQBDIAG, MatConvert_Basic); CHKERRQ(ierr);
  ierr = MatConvertRegister(MATSEQBAIJ, MATMPIBDIAG, MatConvert_Basic); CHKERRQ(ierr);
  ierr = MatConvertRegister(MATSEQBAIJ, MATMPIDENSE, MatConvert_Basic); CHKERRQ(ierr);
  ierr = MatConvertRegister(MATSEQBAIJ, MATSEQBAIJ,  MatConvert_Basic); CHKERRQ(ierr);
  ierr = MatConvertRegister(MATSEQBAIJ, MATMPIBAIJ,  MatConvert_Basic); CHKERRQ(ierr);

  ierr = MatConvertRegister(MATMPIBAIJ, MATSEQDENSE, MatConvert_Basic); CHKERRQ(ierr);
  ierr = MatConvertRegister(MATMPIBAIJ, MATSEQAIJ,   MatConvert_Basic); CHKERRQ(ierr);
  ierr = MatConvertRegister(MATMPIBAIJ, MATMPIAIJ,   MatConvert_Basic); CHKERRQ(ierr);
  ierr = MatConvertRegister(MATMPIBAIJ, MATMPIROWBS, MatConvert_Basic); CHKERRQ(ierr);
  ierr = MatConvertRegister(MATMPIBAIJ, MATSEQBDIAG, MatConvert_Basic); CHKERRQ(ierr);
  ierr = MatConvertRegister(MATMPIBAIJ, MATMPIBDIAG, MatConvert_Basic); CHKERRQ(ierr);
  ierr = MatConvertRegister(MATMPIBAIJ, MATMPIDENSE, MatConvert_Basic); CHKERRQ(ierr);
  ierr = MatConvertRegister(MATMPIBAIJ, MATSEQBAIJ,  MatConvert_Basic); CHKERRQ(ierr);
  ierr = MatConvertRegister(MATMPIBAIJ, MATMPIBAIJ,  MatConvert_Basic); CHKERRQ(ierr);

  ierr = MatConvertRegister(MATSEQCSN, MATSEQDENSE, MatConvert_Basic); CHKERRQ(ierr);
  ierr = MatConvertRegister(MATSEQCSN, MATSEQAIJ,   MatConvert_Basic); CHKERRQ(ierr);
  ierr = MatConvertRegister(MATSEQCSN, MATMPIAIJ,   MatConvert_Basic); CHKERRQ(ierr);
  ierr = MatConvertRegister(MATSEQCSN, MATMPIROWBS, MatConvert_Basic); CHKERRQ(ierr);
  ierr = MatConvertRegister(MATSEQCSN, MATSEQBDIAG, MatConvert_Basic); CHKERRQ(ierr);
  ierr = MatConvertRegister(MATSEQCSN, MATMPIBDIAG, MatConvert_Basic); CHKERRQ(ierr);
  ierr = MatConvertRegister(MATSEQCSN, MATMPIDENSE, MatConvert_Basic); CHKERRQ(ierr);
  ierr = MatConvertRegister(MATSEQCSN, MATSEQBAIJ,  MatConvert_Basic); CHKERRQ(ierr);
  ierr = MatConvertRegister(MATSEQCSN, MATMPIBAIJ,  MatConvert_Basic); CHKERRQ(ierr);

  PetscFunctionReturn(0);
}  

