/* $Id: gvecimpl.h,v 1.11 1998/04/03 23:19:02 bsmith Exp $ */
/*
  This file includes the definition of structures used in PETSc for 
  grids and discrete functions. This should not be included in users' code.
*/

#ifndef __GVECIMPL
#define __GVECIMPL

#include "gvec.h"
#include "da.h"
#include <math.h>

/*
    Discretization operations - these are the operations associated with all 
  type of grids. Note that some of these often actually work on the associated
  vectors. 
*/

struct _GridOps {
   int (*gridsetup)(Grid),
       (*gridduplicate)(Grid,Grid*),
       (*gridrefine)(Grid,int,Grid*),
       (*gridcopy)(Grid,Grid),
       (*gridcreategvec)(Grid,GVec*),
       (*gridcreategmat)(Grid,GMat *),
       (*gvecgetlocalworkgvec)(GVec,GVec*),
       (*gvecrestorelocalworkgvec)(GVec,GVec*),
       (*gvecgetworkgvec)(GVec,GVec*),
       (*gvecrestoreworkgvec)(GVec,GVec*),
       (*gvecglobaltolocal)(GVec,InsertMode,GVec),
       (*gveclocaltoglobal)(GVec,InsertMode,GVec),
       (*gveccreatecomponentgvecs)(GVec,GVecComponents,int *,GVec**),
       (*gvecgetcomponentgvecs)(GVec,GVecComponents,GVec*),       
       (*gvecassemblecomponentgvecs)(GVec,GVecComponents,GVec*),
       (*gvecview)(GVec,Viewer),
       (*gridcreaterestriction)(Grid,Grid,GMat*),
       (*gvecevaluatefunction)(GVec,PointFunction,void*),
       (*gvecevaluatefunctiongalerkin)(GVec,PointFunction,void*),
       (*gmatfdcoloringcreate)(GMat),
       (*destroy)(Grid),
       (*view)(Grid,Viewer);
};

struct _p_Grid {
  PETSCHEADER(struct _GridOps)
  int                 dim;           /* grid dimension (1, 2, or 3) */
  char                **label;       /* string associated with each component */
  GridData            griddata;
  Grid                gridparent;    /* dc that this was refined from */
  int                 setupcalled;
  ISColoring          iscoloring;    /* coloring of nodes */
  MatFDColoring       fdcoloring;    /* context used for evaluation of Jacobian via F.D. */ 
  void                *data;
};

struct _GridDataOps {
   int (*setup)(GridData),
       (*duplicate)(GridData,GridData*),
       (*copy)(GridData,GridData),
       (*creategrid)(GridData,DiscretizationType,Grid*),
       (*refine)(GridData,int,GridData*),
       (*destroy)(GridData),
       (*view)(GridData,Viewer);
};

struct _p_GridData {
  PETSCHEADER(struct _GridDataOps)
  int                     dim;         /* 1, 2 or 3 */
  int                     setupcalled;
  void                    *data;
};

#endif
