#ifdef PETSC_RCS_HEADER
static char vcid[] = "$Id: ex1.c,v 1.5 1997/10/19 03:31:20 bsmith Exp $";
#endif

static char help[] = "Tests creation of grids.\n\n";

#include "gvec.h"

int main(int argc,char **args)
{
  GVec   v, rv;       /* discrete grid vectors (initial and refined) */
  Grid   grid,rgrid;
  int    ierr, n = 10, flag;

  PetscInitialize(&argc,&args,0,help);

  ierr = OptionsGetInt(PETSC_NULL,"-n",&n,&flag); CHKERRA(ierr);

  /*
      Construct the grid and the discretization context
  */
  ierr = GridCreateRectangular1D(PETSC_COMM_WORLD,n,0.0,1.0,PETSC_NULL,DISCRETIZATION_LINEAR,&grid);
         CHKERRA(ierr);

  /* 
      From it create the grid vector
  */
  ierr = GridCreateGVec(grid,&v); CHKERRA(ierr);

  ierr = GVecView(v,VIEWER_STDOUT_WORLD);
  ierr = GVecView(v,VIEWER_DRAWX_WORLD);

  /*
      Create a refined grid and grid vector
  */
  ierr = GridRefine(grid,2,&rgrid); CHKERRA(ierr);
  ierr = GridCreateGVec(rgrid,&rv); CHKERRA(ierr);

  ierr = GVecView(rv,VIEWER_DRAWX_WORLD);

  ierr = VecAssemblyBegin(v); CHKERRA(ierr);
  ierr = VecAssemblyEnd(v); CHKERRA(ierr);
  ierr = VecDestroy(v); CHKERRA(ierr);
  ierr = VecDestroy(rv); CHKERRA(ierr);
  
  ierr = GridDestroy(grid); CHKERRA(ierr); 
  ierr = GridDestroy(rgrid); CHKERRA(ierr); 
  PetscFinalize();
  return 0;
}


