#ifdef PETSC_RCS_HEADER
static char vcid[] = "$Id: zis.c,v 1.23 1998/03/30 22:22:03 balay Exp $";
#endif

#include "src/fortran/custom/zpetsc.h"
#include "is.h"
#ifdef HAVE_FORTRAN_CAPS
#define isdestroy_             ISDESTROY
#define iscreatestride_        ISCREATESTRIDE
#define iscreategeneral_       ISCREATEGENERAL
#define isgetindices_          ISGETINDICES
#define isrestoreindices_      ISRESTOREINDICES
#define isblockgetindices_     ISBLOCKGETINDICES
#define isblockrestoreindices_ ISBLOCKRESTOREINDICES
#define iscreateblock_         ISCREATEBLOCK
#define isblock_               ISBLOCK
#define isstride_              ISSTRIDE
#define ispermutation_         ISPERMUTATION
#define isidentity_            ISIDENTITY
#define issorted_              ISSORTED
#define isequal_               ISEQUAL
#define isinvertpermutation_   ISINVERTPERMUTATION
#define isview_                ISVIEW
#define iscoloringcreate_      ISCOLORINGCREATE
#define islocaltoglobalmappingcreate_ ISLOCALTOGLOBALMAPPINGCREATE
#define isallgather_                  ISALLGATHER
#define iscoloringdestroy_            ISCOLORINGDESTROY
#define iscoloringview_               ISCOLORINGVIEW
#elif !defined(HAVE_FORTRAN_UNDERSCORE)
#define iscoloringview_        iscoloringview
#define iscoloringdestroy_     iscoloringdestroy
#define isview_                isview
#define isinvertpermutation_   isinvertpermutation
#define isdestroy_             isdestroy
#define iscreatestride_        iscreatestride
#define iscreategeneral_       iscreategeneral
#define isgetindices_          isgetindices
#define isrestoreindices_      isrestoreindices
#define isblockgetindices_     isblockgetindices
#define isblockrestoreindices_ isblockrestoreindices
#define iscreateblock_         iscreateblock
#define isblock_               isblock
#define isstride_              isstride
#define ispermutation_         ispermutation
#define isidentity_            isidentity
#define issorted_              issorted
#define isequal_               isequal
#define iscoloringcreate_      iscoloringcreate
#define islocaltoglobalmappingcreate_ islocaltoglobalmappingcreate
#define isallgather_                  isallgather
#endif

#if defined(__cplusplus)
extern "C" {
#endif

void iscoloringdestroy_(ISColoring *iscoloring, int *__ierr )
{
  *__ierr = ISColoringDestroy((ISColoring)PetscToPointer(iscoloring));
  PetscRmPointer(iscoloring);
}

void iscoloringview_(ISColoring *iscoloring,Viewer viewer, int *__ierr )
{
  *__ierr = ISColoringView((ISColoring)PetscToPointer(iscoloring),
	                   (Viewer)PetscToPointer(viewer));
}

void isview_(IS is,Viewer viewer, int *__ierr )
{
  PetscPatchDefaultViewers_Fortran(viewer);
  *__ierr = ISView((IS)PetscToPointer(is),viewer);
}

void isequal_(IS is1,IS is2,PetscTruth *flg, int *__ierr )
{
  *__ierr = ISEqual((IS)PetscToPointer(is1),
	          (IS)PetscToPointer(is2), flg);
}

void isidentity_(IS is,PetscTruth *ident, int *__ierr )
{
  *__ierr = ISIdentity((IS)PetscToPointer(is),ident);
}
void issorted_(IS is,PetscTruth *flg, int *__ierr )
{
  *__ierr = ISSorted((IS)PetscToPointer(is),flg);
}

void ispermutation_(IS is,PetscTruth *perm, int *__ierr ){
  *__ierr = ISPermutation((IS)PetscToPointer(is),perm);
}

void isstride_(IS is,PetscTruth *flag, int *__ierr )
{
  *__ierr = ISStride((IS)PetscToPointer(is),flag);
}

void isblockgetindices_(IS x,int *fa,long *ia,int *__ierr)
{
  IS    xin = (IS)PetscToPointer(x);
  int   *lx;

  *__ierr = ISGetIndices(xin,&lx); if (*__ierr) return;
  *ia      = PetscIntAddressToFortran(fa,lx);
}

void isblockrestoreindices_(IS x,int *fa,long *ia,int *__ierr)
{
  IS    xin = (IS)PetscToPointer(x);
  int *lx = PetscIntAddressFromFortran(fa,*ia);

  *__ierr = ISRestoreIndices(xin,&lx);
}

void isblock_(IS is,PetscTruth *flag, int *__ierr )
{
  *__ierr = ISBlock((IS)PetscToPointer(is),flag);
}

void isgetindices_(IS x,int *fa,long *ia,int *__ierr)
{
  IS    xin = (IS)PetscToPointer(x);
  int   *lx;

  *__ierr = ISGetIndices(xin,&lx); if (*__ierr) return;
  *ia      = PetscIntAddressToFortran(fa,lx);
}

void isrestoreindices_(IS x,int *fa,long *ia,int *__ierr)
{
  IS    xin = (IS)PetscToPointer(x);
  int *lx = PetscIntAddressFromFortran(fa,*ia);

  *__ierr = ISRestoreIndices(xin,&lx);
}

void iscreategeneral_(MPI_Comm *comm,int *n,int *idx,IS *is, int *__ierr ){
  IS ii;
  *__ierr = ISCreateGeneral(
	(MPI_Comm)PetscToPointerComm( *comm ),*n,idx,&ii);
  *(PetscFortranAddr*) is = PetscFromPointer(ii);
}

void isinvertpermutation_(IS is,IS *isout, int *__ierr )
{
  IS ii;
  *__ierr = ISInvertPermutation((IS)PetscToPointer(is),&ii);
  *(PetscFortranAddr*) isout = PetscFromPointer(ii);
}

void iscreateblock_(MPI_Comm *comm,int *bs,int *n,int *idx,IS *is, int *__ierr ){
  IS ii;
  *__ierr = ISCreateBlock(
	(MPI_Comm)PetscToPointerComm( *comm ),*bs,*n,idx,&ii);
  *(PetscFortranAddr*) is = PetscFromPointer(ii);
}

void iscreatestride_(MPI_Comm *comm,int *n,int *first,int *step,
                               IS *is, int *__ierr ){
  IS ii;
  *__ierr = ISCreateStride(
	(MPI_Comm)PetscToPointerComm( *comm ),*n,*first,*step,&ii);
  *(PetscFortranAddr*) is = PetscFromPointer(ii);
}

void isdestroy_(IS is, int *__ierr ){
  *__ierr = ISDestroy((IS)PetscToPointer(is));
  PetscRmPointer(is);
}

void iscoloringcreate_(MPI_Comm *comm,int *n,int *colors,ISColoring *iscoloring, int *__ierr )
{
  ISColoring ii;

  *__ierr = ISColoringCreate((MPI_Comm)PetscToPointerComm( *comm ),*n,colors,&ii);
  *(PetscFortranAddr*) iscoloring = PetscFromPointer(ii);
}

void islocaltoglobalmappingcreate_(MPI_Comm *comm,int *n,int *indices,ISLocalToGlobalMapping 
                                   *mapping, int *__ierr )
{
  ISLocalToGlobalMapping ii;
  *__ierr = ISLocalToGlobalMappingCreate((MPI_Comm)PetscToPointerComm(*comm),*n,indices,&ii);
  *(PetscFortranAddr*) mapping = PetscFromPointer(ii);
}

void isallgather_(IS is,IS *isout, int *__ierr ){
IS islocal;
*__ierr = ISAllGather(
	(IS)PetscToPointer(is) ,&islocal);
        *(PetscFortranAddr*) isout = PetscFromPointer(islocal);

}

#if defined(__cplusplus)
}
#endif
