#ifdef PETSC_RCS_HEADER
static char vcid[] = "$Id: zgvec.c,v 1.9 1998/04/02 23:41:28 balay Exp $";
#endif

#include "src/fortran/custom/zpetsc.h"
#include "gvec.h"
#ifdef HAVE_FORTRAN_CAPS
#define griddatacreaterectangular1d_ GRIDDATACREATERECTANGULAR1D
#define gridcreaterectangular1d_     GRIDCREATERECTANGULAR1D
#define griddatacreaterectangular2d_ GRIDDATACREATERECTANGULAR2D
#define gridcreaterectangular2d_     GRIDCREATERECTANGULAR2D
#elif !defined(HAVE_FORTRAN_UNDERSCORE)
#define griddatacreaterectangular1d_ griddatacreaterectangular1d
#define gridcreaterectangular1d_     gridcreaterectangular1d
#define griddatacreaterectangular2d_ griddatacreaterectangular2d
#define gridcreaterectangular2d_     gridcreaterectangular2d
#endif

#if defined(__cplusplus)
extern "C" {
#endif

void griddatacreaterectangular1d_(MPI_Comm *comm,int *m,double *xmin,double *xmax,
                                double *points,GridData *grid, int *__ierr ){
*__ierr = GridDataCreateRectangular1D(
        (MPI_Comm)PetscToPointerComm( *comm ),*m,*xmin,*xmax,points,
        (GridData* )PetscToPointer(grid));
}
void gridcreaterectangular1d_(MPI_Comm *comm,int *n,double *xmin,double *xmax,double *x,
                            DiscretizationType *dtype,Grid *grid, int *__ierr ){
*__ierr = GridCreateRectangular1D(
        (MPI_Comm)PetscToPointerComm( *comm ),*n,*xmin,*xmax,x,*dtype,grid);
}

void griddatacreaterectangular2d_(MPI_Comm *comm,int *m,double *xmin,double *xmax,
                                double *xpoints,int *n,double *ymin,double *ymax,
                                double *ypoints,GridData *grid, int *__ierr ){
*__ierr = GridDataCreateRectangular2D(
        (MPI_Comm)PetscToPointerComm( *comm ),*m,*xmin,*xmax,xpoints,*n,*ymin,*ymax,ypoints,
        (GridData* )PetscToPointer(grid));
}
void gridcreaterectangular2d_(MPI_Comm *comm,int *m,double *xmin,double *xmax,double *x,
                            int *n,double *ymin,double *ymax,double *y,
                            DiscretizationType *dtype,Grid *grid, int *__ierr ){
*__ierr = GridCreateRectangular2D(
        (MPI_Comm)PetscToPointerComm( *comm ),*m,*xmin,*xmax,x,*n,*ymin,*ymax,y,*dtype,grid);
}


#if defined(__cplusplus)
}
#endif
