/* $Id: vrmlimpl.h,v 1.11 1997/10/19 03:27:58 bsmith Exp $ */

/*
      Defines the internal data structures for the VRML
      implementation of the graphics functionality in PETSc.

      Note in particular that VRML (particularly version 1)
      is almost the same as SGI's inventor, so there is an option to
      generate Inventor instead of VRML.  This allows use of the
      QuadMesh Inventor form for meshes for improved performance.
*/

#include "src/draw/drawimpl.h"
#include "sys.h"

#if !defined(_VRMLIMPL_H)
#define _VRMLIMPL_H

#include <sys/types.h>

/* 
 * Types of VRML output operations
 */
typedef enum { VRML_LINE, VRML_POINT, VRML_TRIANGLE, VRML_NONE, 
	       VRML_OTHER } VRMLObj;

/* Color mapping types */
typedef enum { COLOR_MAP_LINEAR, COLOR_MAP_EQUAL_N, COLOR_MAP_EQUAL_AREA }
    ColorMapType;

/* This structure allows us to precompute useful data about 3d mesh data */
struct _p_DrawMesh {
    double *x, *y, *z;                      /* Coordinate values */
    int    nx, ny, nz;
    int    si, ei, sj, ej, sk, ek,          /* Section to draw */
	   i_incr, j_incr, k_incr;
    double xmin, xmax, ymin, ymax, zmin, zmax;
    double *f;                              /* Data values */
    double fmin, fmax;
    double fmin_use, fmax_use;              /* Only use values >= fmin_use
					       and <= fmax_use. */
    /* Slice definitions */
    int    act_nx, act_ny;                  /* When a slice is used,
					       this defines sizes. 
					       Used in vertex drawing */
    int    is, ie, js, je, ks, ke;

    /* The following data is used to map colors for values in the data
       set */
    double *(rgb[3]);
    int    ncolors;
    double *color_thresh;                   /* Array used to separate out
					       the selected colors.  This
					       can also be used to fit 
					       a polynomial to the values in
					       f, and used directly with 
					       ViGetHue using p(f) instead of 
					       f */
};

typedef struct {
    FILE     *fp;                           /* File for output */
    FILE     *curfp;                        /* Used for current output */
    char     *fname_form;                   /* Used for opening a sequence
					       of files */
    char     *wwwname_form;                 /* Corresponding WWW name for 
					       fname_form */
    double   z;                            /* Base z value (if unspecified) */
    VRMLObj  last_obj;                      /* Last object */
    double   last_x, last_y, last_z;        /* Last coords used */
    double   cur_red, cur_green, cur_blue;  /* Last colors */
    int      line_segs;                     /* Number of segments in 
					       current line */
    int      pagenum;                       /* Current "page" number */
    int      use_LOD;                       /* Indicates whether LOD 
					       information should be in VRML */
    double   LOD_thresh;                    /* multiplier for LOD range */
    int      vrml_version;                  /* Hook for vrml 1 or 2 */
    int      is_inventor;                   /* Hook for generating Inventor
					       instead */
    int      is_human_coord;                /* Hook for making z up instead
                                               of in */

    /* Additional drawing operations (class VRML extends DRAW ... ) */
    int      (*DrawTensorSurface)( Draw, DrawMesh, int );
    int      (*DrawTensorSurfaceContour)( Draw, DrawMesh, VRMLGetHue_fcn,
					  void *, int );
    int      (*DrawTensorMapSurfaceContour)( Draw, DrawMesh, 
					     double, double, double, int, int,
					     VRMLGetHue_fcn,
					     void *, int, double );
    int      (*DrawTensorMapMesh)( Draw, DrawMesh, double, double, double,
				   int, int );
					  
    
} Draw_VRML;

/* Local definitions */
#define PRECISION 3

void Vi_Out_double_VRML( FILE *, double, int );

int ViSetupMeshVertices( Draw_VRML *, DrawMesh, int, int );
int ViOutMeshVertices( Draw_VRML *, DrawMesh, int, int, double, double, 
		       double, int );
int ViDrawTensorSurfaceContour_IV( Draw, DrawMesh, VRMLGetHue_fcn, void *, 
				   int );
int ViDrawTensorMapSurfaceContour_IV( Draw, DrawMesh, 
					     double, double, double, int, int,
					     VRMLGetHue_fcn,
					     void *, int, double );
int ViDrawTensorMapMesh_IV( Draw, DrawMesh, double, double, double,
			    int, int );

#endif
