
/* $Id: regbase.c,v 1.16 1997/12/01 01:56:26 bsmith Exp $ */

/* 
   Defines some vector operation functions that are shared by 
   sequential and parallel vector/grid utilities.
*/

#include "src/dfvec/dfvimpl.h" 
#include "src/vec/vecimpl.h"

#undef __FUNC__  
#define __FUNC__ "DFCopy_SeqRegular"
int DFCopy_SeqRegular(DF df,DF df2)
{
  int    mx, my, mz, i;
  double *x, *y, *z, *x2, *y2, *z2;

  PetscFunctionBegin;
  if (df->cset) { /* Copy coordinates if they've been set */
    mx = df->gnp[0]; x = df->coord[0];
    my = df->gnp[1]; y = df->coord[1];
    mz = df->gnp[2]; z = df->coord[2];
    if (mx !=  df2->gnp[0] || my !=  df2->gnp[1] || mz !=  df2->gnp[2]){
      SETERRQ(PETSC_ERR_ARG_SIZ,0,"Incompatible DF sizes"); 
    }
    if (!df2->cset) { /* Allocate new coordinates if necessary */
      df2->coord[0] = (double *) PetscMalloc( mx*sizeof(double) ); CHKPTRA(df2->coord[0]);
      df2->coord[1] = (double *) PetscMalloc( my*sizeof(double) ); CHKPTRA(df2->coord[1]);
      df2->coord[2] = (double *) PetscMalloc( mz*sizeof(double) ); CHKPTRA(df2->coord[2]);
      df2->calloc = 1;
    }
    x2 = df2->coord[0]; y2 = df2->coord[1]; z2 = df2->coord[2];
    for (i=0; i<mx; i++) x2[i] = x[i];
    for (i=0; i<my; i++) y2[i] = y[i];
    for (i=0; i<mz; i++) z2[i] = z[i];
    df2->cset = 1;
  }
  PetscFunctionReturn(0);
}

#undef __FUNC__  
#define __FUNC__ "DFRefineCoordinates_SeqRegular"
int DFRefineCoordinates_SeqRegular(DF df,DF dfref)
{
  int    i, mx, my, mz;
  double *x, *y, *z, *x2, *y2, *z2;

  PetscFunctionBegin;
  mx = df->gnp[0]; x = df->coord[0];
  my = df->gnp[1]; y = df->coord[1];
  mz = df->gnp[2]; z = df->coord[2];

  x2 = (double*)PetscMalloc((mx*2-1)*sizeof(double)); CHKPTRQ(x2);
  dfref->calloc = 1;
  dfref->cset   = 1;
  x2[0] = x[0];
  for (i=1; i<mx; i++) {
    x2[2*i]   = x[i];
    x2[2*i-1] = 0.5*(x[i] + x[i-1]);
  }
  y2 = 0; z2 = 0;
  if (df->dim >= 2) {
    y2 = (double*)PetscMalloc((my*2-1)*sizeof(double)); CHKPTRQ(y2);
    y2[0] = y[0];
    for (i=1; i<my; i++) {
      y2[2*i]   = y[i];
      y2[2*i-1] = 0.5*(y[i] + y[i-1]);
    }
    if (df->dim >= 3) {
      z2 = (double*)PetscMalloc((mz*2-1)*sizeof(double)); CHKPTRQ(z2);
      z2[0] = z[0];
      for (i=1; i<mz; i++) {
        z2[2*i]   = z[i];
        z2[2*i-1] = 0.5*(z[i] + z[i-1]);
      }
    } 
    else {
      z2 = (double*)PetscMalloc(sizeof(double)); CHKPTRQ(z2); z2[0]=0.0;
    }
  } 
  else {
    y2 = (double*)PetscMalloc(sizeof(double)); CHKPTRQ(y2); y2[0]=0.0;
    z2 = (double*)PetscMalloc(sizeof(double)); CHKPTRQ(z2); z2[0]=0.0;
  }
  dfref->coord[0] = x2;
  dfref->coord[1] = y2;
  dfref->coord[2] = z2;

  PetscFunctionReturn(0);
}
