#ifdef PETSC_RCS_HEADER
static char vcid[] = "$Id: gendf.c,v 1.19 1998/03/12 23:22:08 bsmith Exp $";
#endif

/*
   Implements general sequential discrete function utilities.
*/
#include "src/dfvec/dfvimpl.h" 
#include "src/vec/vecimpl.h"

#undef __FUNC__  
#define __FUNC__ "DFVecAssembleFullVector_SeqGeneral" 
int DFVecAssembleFullVector_SeqGeneral(Vec *vsub,DFVec v)
{
  VecScatter vsctx;
  int        ierr, i, gsize, sz, nc, size;
  IS         is, newis;
  DF         df;

  ierr = DFVecGetDFShell(v,&df); CHKERRQ(ierr);
  nc   = df->nc;
  ierr = VecGetSize(v,&gsize); CHKERRQ(ierr);
  ierr = VecGetSize(vsub[0],&size); CHKERRQ(ierr);
  for (i=0; i<nc; i++) {
    ierr = VecGetSize(vsub[i],&sz); CHKERRQ(ierr);
    if (sz != size) 
      SETERRQ(PETSC_ERR_ARG_SIZ,0,"All subvecs must be same size ");
  }
  if (sz*nc != gsize)
    SETERRQ(PETSC_ERR_ARG_SIZ,0,"Incompatible subvecs with global vec");
  if (nc == 1) {
    ierr = VecCopy(vsub[0],v); CHKERRQ(ierr);
  } 
  else {
    if (df->order != ORDER_1 && df->order != ORDER_2) {
      SETERRQ(PETSC_ERR_SUP,0,"Ordering not supported.");
    }
    ierr = ISCreateStride(PETSC_COMM_SELF,size,0,1,&newis); CHKERRQ(ierr);
    for (i=0; i<nc; i++) {
      if (df->order == ORDER_1) {
        ierr = ISCreateStride(PETSC_COMM_SELF,size,i,nc,&is); CHKERRQ(ierr);
      }
      else if (df->order == ORDER_2) {
        ierr = ISCreateStride(PETSC_COMM_SELF,size,i*size,1,&is); CHKERRQ(ierr);
      }
      ierr = VecScatterCreate(vsub[i],newis,v,is,&vsctx); CHKERRQ(ierr);
      ierr = VecScatterBegin(vsub[i],v,INSERT_VALUES,SCATTER_FORWARD,vsctx);CHKERRQ(ierr);
      ierr = VecScatterEnd(vsub[i],v,INSERT_VALUES,SCATTER_FORWARD,vsctx); CHKERRQ(ierr);
      ierr = VecScatterDestroy(vsctx); CHKERRQ(ierr);
      ierr = ISDestroy(is); CHKERRQ(ierr);
    }
  ierr = ISDestroy(newis); CHKERRQ(ierr);
  }
  PetscFunctionReturn(0);
}

static struct _DFOps DFSeqGeneralOps = 
   {0,0,DFVecAssembleFullVector_SeqGeneral,0,0};

#undef __FUNC__  
#define __FUNC__ "DFSetSeqGeneralOps_Private"
int DFSetSeqGeneralOps_Private(DF v)
{
  PetscMemcpy(v->ops,&DFSeqGeneralOps,sizeof(DFSeqGeneralOps));
  PetscFunctionReturn(0);
}
